/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.sshd.client.SshdSocketAddress;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.util.Buffer;

public class ChannelDirectTcpip
extends AbstractClientChannel {
    private final SshdSocketAddress local;
    private final SshdSocketAddress remote;
    private final PipedOutputStream pipe = new PipedOutputStream();

    public ChannelDirectTcpip(SshdSocketAddress local, SshdSocketAddress remote) {
        super("direct-tcpip");
        if (local == null) {
            try {
                local = new SshdSocketAddress(InetAddress.getLocalHost().getHostName(), 0);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Unable to retrieve local host name");
            }
        }
        if (remote == null) {
            throw new IllegalArgumentException("Remote address must not be null");
        }
        this.local = local;
        this.remote = remote;
    }

    protected OpenFuture internalOpen() throws Exception {
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.lock);
        this.log.info("Send SSH_MSG_CHANNEL_OPEN on channel {}", (Object)this.id);
        Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN, 0);
        buffer.putString(this.type);
        buffer.putInt(this.id);
        buffer.putInt(this.localWindow.getSize());
        buffer.putInt(this.localWindow.getPacketSize());
        buffer.putString(this.remote.getHostName());
        buffer.putInt(this.remote.getPort());
        buffer.putString(this.local.getHostName());
        buffer.putInt(this.local.getPort());
        this.session.writePacket(buffer);
        return this.openFuture;
    }

    protected void doOpen() throws Exception {
        this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        this.in = new PipedInputStream(this.pipe);
    }

    public OpenFuture open() throws Exception {
        return this.internalOpen();
    }

    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        this.pipe.write(data, off, len);
        this.pipe.flush();
        this.localWindow.consumeAndCheck(len);
    }
}

