/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.sshd.client.SshdSocketAddress;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;

public class TcpipForwardSupport
extends IoHandlerAdapter {
    private final ClientSessionImpl session;
    private IoAcceptor acceptor;
    private Map<Integer, SshdSocketAddress> forwards = new HashMap<Integer, SshdSocketAddress>();

    public TcpipForwardSupport(ClientSessionImpl session) {
        this.session = session;
    }

    public synchronized void initialize() {
        if (this.acceptor == null) {
            NioSocketAcceptor acceptor = this.session.getClientFactoryManager().getTcpipForwardingAcceptorFactory().createNioSocketAcceptor(this.session);
            acceptor.setHandler((IoHandler)this);
            acceptor.setReuseAddress(true);
            acceptor.getFilterChain().addLast("executor", (IoFilter)new ExecutorFilter(EnumSet.complementOf(EnumSet.of(IoEventType.SESSION_CREATED)).toArray(new IoEventType[0])));
            this.acceptor = acceptor;
        }
    }

    public synchronized void close() {
        if (this.acceptor != null) {
            this.acceptor.dispose();
            this.acceptor = null;
        }
    }

    synchronized void request(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        this.initialize();
        boolean ok = false;
        if (this.forwards.get(local.getPort()) != null) {
            throw new IOException("The local port is already forwarded");
        }
        this.acceptor.bind(new SocketAddress[]{local.toInetSocketAddress()});
        this.forwards.put(local.getPort(), remote);
    }

    synchronized void cancel(SshdSocketAddress local) throws IOException {
        this.forwards.remove(local.getPort());
        if (this.acceptor != null) {
            this.acceptor.unbind((SocketAddress)local.toInetSocketAddress());
        }
    }

    public void sessionCreated(IoSession session) throws Exception {
        SshdSocketAddress remote = this.forwards.get(((InetSocketAddress)session.getLocalAddress()).getPort());
        final ChannelForwardedTcpip channel = new ChannelForwardedTcpip(session, remote);
        session.setAttribute(ChannelForwardedTcpip.class, (Object)channel);
        this.session.registerChannel(channel);
        channel.open().addListener(new SshFutureListener<OpenFuture>(){

            @Override
            public void operationComplete(OpenFuture future) {
                Throwable t = future.getException();
                if (t != null) {
                    TcpipForwardSupport.this.session.unregisterChannel(channel);
                    channel.close(false);
                }
            }
        });
    }

    public void sessionClosed(IoSession session) throws Exception {
        ChannelForwardedTcpip channel = (ChannelForwardedTcpip)session.getAttribute(ChannelForwardedTcpip.class);
        if (channel != null) {
            channel.close(false);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        ChannelForwardedTcpip channel = (ChannelForwardedTcpip)session.getAttribute(ChannelForwardedTcpip.class);
        IoBuffer ioBuffer = (IoBuffer)message;
        int r = ioBuffer.remaining();
        byte[] b = new byte[r];
        ioBuffer.get(b, 0, r);
        channel.waitFor(130, Long.MAX_VALUE);
        channel.getOut().write(b, 0, r);
        channel.getOut().flush();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
        session.close(false);
    }

    public static class ChannelForwardedTcpip
    extends AbstractClientChannel {
        private final IoSession serverSession;
        private final SshdSocketAddress remote;

        public ChannelForwardedTcpip(IoSession serverSession, SshdSocketAddress remote) {
            super("direct-tcpip");
            this.serverSession = serverSession;
            this.remote = remote;
        }

        public OpenFuture getOpenFuture() {
            return this.openFuture;
        }

        public synchronized OpenFuture open() throws Exception {
            InetSocketAddress origin = (InetSocketAddress)this.serverSession.getRemoteAddress();
            InetSocketAddress remote = this.remote.toInetSocketAddress();
            if (this.closeFuture.isClosed()) {
                throw new SshException("Session has been closed");
            }
            this.openFuture = new DefaultOpenFuture(this.lock);
            this.log.info("Send SSH_MSG_CHANNEL_OPEN on channel {}", (Object)this.id);
            Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN, 0);
            buffer.putString(this.type);
            buffer.putInt(this.id);
            buffer.putInt(this.localWindow.getSize());
            buffer.putInt(this.localWindow.getPacketSize());
            buffer.putString(remote.getAddress().getHostAddress());
            buffer.putInt(remote.getPort());
            buffer.putString(origin.getAddress().getHostAddress());
            buffer.putInt(origin.getPort());
            this.session.writePacket(buffer);
            return this.openFuture;
        }

        protected synchronized void doOpen() throws Exception {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        }

        protected synchronized void doClose() {
            this.serverSession.close(false);
            super.doClose();
        }

        protected synchronized void doWriteData(byte[] data, int off, int len) throws IOException {
            IoBuffer buf = IoBuffer.allocate((int)len);
            buf.put(data, off, len);
            buf.flip();
            this.localWindow.consumeAndCheck(len);
            this.serverSession.write((Object)buf);
        }

        public void handleEof() throws IOException {
            super.handleEof();
            this.serverSession.close(false);
        }
    }
}

