/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.BasicConfigurator;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.ServerResponseDeliveryAdapter;
import org.jsmpp.session.Session;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPServerSimulator
extends ServerResponseDeliveryAdapter
implements Runnable,
ServerMessageReceiverListener {
    private static final Integer DEFAULT_PORT = 8056;
    private static final Logger logger = LoggerFactory.getLogger(SMPPServerSimulator.class);
    private final ExecutorService execService = Executors.newFixedThreadPool(5);
    private final ExecutorService execServiceDelReciept = Executors.newFixedThreadPool(100);
    private final MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private int port;

    public SMPPServerSimulator(int port) {
        this.port = port;
    }

    public void run() {
        try {
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(this.port);
            logger.info("Listening on port {}", (Object)this.port);
            while (true) {
                SMPPServerSession serverSession = sessionListener.accept();
                logger.info("Accepting connection for session {}", (Object)serverSession.getSessionId());
                serverSession.setMessageReceiverListener(this);
                serverSession.setResponseDeliveryListener(this);
                this.execService.execute(new WaitBindTask(serverSession));
            }
        }
        catch (IOException e) {
            logger.error("IO error occured", (Throwable)e);
            return;
        }
    }

    public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
        logger.info("Accepting query sm, but not implemented");
        return null;
    }

    public MessageId onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        logger.debug("Receiving submit_sm {}, and return message id {}", (Object)new String(submitSm.getShortMessage()), (Object)messageId.getValue());
        if (SMSCDeliveryReceipt.SUCCESS.containedIn(submitSm.getRegisteredDelivery()) || SMSCDeliveryReceipt.SUCCESS_FAILURE.containedIn(submitSm.getRegisteredDelivery())) {
            this.execServiceDelReciept.execute(new DeliveryReceiptTask(source, submitSm, messageId));
        }
        return messageId;
    }

    public void onSubmitSmRespSent(MessageId messageId, SMPPServerSession source) {
        logger.debug("submit_sm_resp with message_id {} has been sent", (Object)messageId);
    }

    public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
        return null;
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
        return null;
    }

    public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
    }

    public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
    }

    public static void main(String[] args) {
        int port;
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.simulator.port", DEFAULT_PORT.toString()));
        }
        catch (NumberFormatException e) {
            port = DEFAULT_PORT;
        }
        BasicConfigurator.configure();
        SMPPServerSimulator smppServerSim = new SMPPServerSimulator(port);
        smppServerSim.run();
    }

    private class DeliveryReceiptTask
    implements Runnable {
        private final SMPPServerSession session;
        private final SubmitSm submitSm;
        private MessageId messageId;

        public DeliveryReceiptTask(SMPPServerSession session, SubmitSm submitSm, MessageId messageId) {
            this.session = session;
            this.submitSm = submitSm;
            this.messageId = messageId;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            String stringValue = Integer.valueOf(this.messageId.getValue(), 16).toString();
            try {
                DeliveryReceipt delRec = new DeliveryReceipt(stringValue, 1, 1, new Date(), new Date(), DeliveryReceiptState.DELIVRD, null, new String(this.submitSm.getShortMessage()));
                this.session.deliverShortMessage("mc", TypeOfNumber.valueOf(this.submitSm.getDestAddrTon()), NumberingPlanIndicator.valueOf(this.submitSm.getDestAddrNpi()), this.submitSm.getDestAddress(), TypeOfNumber.valueOf(this.submitSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf(this.submitSm.getSourceAddrNpi()), this.submitSm.getSourceAddr(), new ESMClass(MessageMode.DEFAULT, MessageType.SMSC_DEL_RECEIPT, GSMSpecificFeature.DEFAULT), (byte)0, (byte)0, new RegisteredDelivery(0), DataCoding.newInstance(0), delRec.toString().getBytes(), new OptionalParameter[0]);
                logger.debug("Sending delivery reciept for message id " + this.messageId + ":" + stringValue);
            }
            catch (Exception e) {
                logger.error("Failed sending delivery_receipt for message id " + this.messageId + ":" + stringValue, (Throwable)e);
            }
        }
    }

    private class WaitBindTask
    implements Runnable {
        private final SMPPServerSession serverSession;

        public WaitBindTask(SMPPServerSession serverSession) {
            this.serverSession = serverSession;
        }

        public void run() {
            try {
                BindRequest bindRequest = this.serverSession.waitForBind(1000L);
                logger.info("Accepting bind for session {}", (Object)this.serverSession.getSessionId());
                try {
                    bindRequest.accept("sys");
                }
                catch (PDUStringException e) {
                    logger.error("Invalid system id", (Throwable)e);
                    bindRequest.reject(8);
                }
            }
            catch (IllegalStateException e) {
                logger.error("System error", (Throwable)e);
            }
            catch (TimeoutException e) {
                logger.warn("Wait for bind has reach timeout", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Failed accepting bind request for session {}", (Object)this.serverSession.getSessionId());
            }
        }
    }
}

