/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.extra;

import org.jsmpp.InvalidResponseException;
import org.jsmpp.bean.Command;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ResponseTimeoutException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingResponseTest {
    private PendingResponse<Command> pendingResponse;

    @BeforeMethod
    public void setUp() throws Exception {
        this.pendingResponse = new PendingResponse(1000L);
    }

    @Test(groups={"checkintest"})
    public void testReachTimeout() {
        try {
            PendingResponseTest.notifyDone(1010L, this.pendingResponse);
            this.pendingResponse.waitDone();
            Assert.fail((String)"Timeout should be reached");
        }
        catch (ResponseTimeoutException responseTimeoutException) {
        }
        catch (InvalidResponseException e) {
            Assert.fail((String)"Timeout should be reached");
        }
    }

    @Test(groups={"checkintest"})
    public void testUnreachTimeout() {
        try {
            PendingResponseTest.notifyDone(90L, this.pendingResponse);
            this.pendingResponse.waitDone();
        }
        catch (ResponseTimeoutException e) {
            Assert.fail((String)"Should be done with valid response");
        }
        catch (InvalidResponseException e) {
            Assert.fail((String)"Should be done with valid response");
        }
    }

    @Test(groups={"checkintest"})
    public void testDoneWithInvalidResponse() {
        try {
            PendingResponseTest.notifyInvalidResponse(90L, this.pendingResponse);
            this.pendingResponse.waitDone();
            System.out.println("DONE");
            Assert.fail((String)"Should throw InvalidResponseException");
        }
        catch (ResponseTimeoutException e) {
            Assert.fail((String)"Should throw InvalidResponseException");
        }
        catch (InvalidResponseException invalidResponseException) {
            // empty catch block
        }
    }

    private static void notifyDone(final long timemillis, final PendingResponse<Command> pendingResponse) {
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(timemillis);
                    pendingResponse.done(new Command());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    private static void notifyInvalidResponse(final long timemillis, final PendingResponse<Command> pendingResponse) {
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(timemillis);
                    pendingResponse.doneWithInvalidResponse(new InvalidResponseException("Invalid response message"));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }
}

