/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BindResp;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.PDUByteBuffer;
import org.jsmpp.util.SequentialBytesReader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ComposerDecomposerReaderTest {
    private static final boolean DEBUG = false;

    @Test(groups={"checkintest"})
    public void lowLevel() {
        byte[] b = null;
        String systemId = "smsc";
        PDUByteBuffer buf = new PDUByteBuffer(BindType.BIND_TRX.responseCommandId(), 0, 1);
        buf.append(systemId);
        b = buf.toBytes();
        Assert.assertEquals((int)b.length, (int)(16 + systemId.length() + 1));
        ComposerDecomposerReaderTest.printLog("Length of bytes : " + b.length);
        SequentialBytesReader reader = new SequentialBytesReader(b);
        Assert.assertEquals((int)b.length, (int)reader.remainBytesLength());
        int commandLength = reader.readInt();
        Assert.assertEquals((int)commandLength, (int)b.length);
        Assert.assertEquals((int)4, (int)reader.cursor);
        Assert.assertEquals((int)(b.length - 4), (int)reader.remainBytesLength());
        int commandId = reader.readInt();
        Assert.assertEquals((int)commandId, (int)BindType.BIND_TRX.responseCommandId());
        Assert.assertEquals((int)8, (int)reader.cursor);
        Assert.assertEquals((int)(b.length - 8), (int)reader.remainBytesLength());
        int commandStatus = reader.readInt();
        Assert.assertEquals((int)commandStatus, (int)0);
        Assert.assertEquals((int)12, (int)reader.cursor);
        Assert.assertEquals((int)(b.length - 12), (int)reader.remainBytesLength());
        int sequenceNumber = reader.readInt();
        Assert.assertEquals((int)sequenceNumber, (int)1);
        Assert.assertEquals((int)16, (int)reader.cursor);
        Assert.assertEquals((int)(b.length - 16), (int)reader.remainBytesLength());
        String readedSystemId = reader.readCString();
        Assert.assertEquals((String)readedSystemId, (String)systemId);
    }

    @Test(groups={"checkintest"})
    public void highLevel() {
        DefaultComposer composer = new DefaultComposer();
        DefaultDecomposer decomposer = new DefaultDecomposer();
        byte[] b = null;
        String systemId = "smsc";
        BindType bindType = BindType.BIND_TRX;
        try {
            b = composer.bindResp(bindType.responseCommandId(), 1, systemId, new OptionalParameter[0]);
            Assert.assertEquals((int)b.length, (int)(16 + systemId.length() + 1));
            ComposerDecomposerReaderTest.printLog("Length of bytes : " + b.length);
        }
        catch (PDUStringException e) {
            Assert.fail((String)"Failed composing bind response", (Throwable)e);
        }
        try {
            BindResp resp = decomposer.bindResp(b);
            Assert.assertEquals((int)resp.getCommandLength(), (int)b.length);
            Assert.assertEquals((int)resp.getCommandId(), (int)bindType.responseCommandId());
            Assert.assertEquals((int)resp.getCommandStatus(), (int)0);
            Assert.assertEquals((int)resp.getSequenceNumber(), (int)1);
            Assert.assertEquals((String)resp.getSystemId(), (String)systemId);
        }
        catch (PDUStringException e) {
            Assert.fail((String)"Failed decomposing bind response", (Throwable)e);
        }
    }

    private static void printLog(String message) {
    }
}

