/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean.support;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import org.apache.servicemix.bean.BeanEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    private final Object bean;
    private Map<Method, Boolean> callbacks;
    private final Object correlationId;
    private final Set<MessageExchange> exchanges = new HashSet<MessageExchange>();

    public Request(Object correlationId, Object bean, MessageExchange exchange) {
        this.correlationId = correlationId;
        this.bean = bean;
        this.exchanges.add(exchange);
    }

    public Object getBean() {
        return this.bean;
    }

    public Object getCorrelationId() {
        return this.correlationId;
    }

    public Map<Method, Boolean> getCallbacks() {
        if (this.callbacks == null) {
            this.callbacks = new HashMap<Method, Boolean>();
        }
        return this.callbacks;
    }

    public boolean isFinished() {
        for (MessageExchange exchange : this.exchanges) {
            if (!ExchangeStatus.ACTIVE.equals(exchange.getStatus())) continue;
            return false;
        }
        return true;
    }

    public void addExchange(MessageExchange exchange) {
        this.exchanges.add(exchange);
        exchange.setProperty(BeanEndpoint.CORRELATION_ID, this.correlationId);
    }

    public Set<MessageExchange> getExchanges() {
        return Collections.unmodifiableSet(this.exchanges);
    }
}

