/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import jnr.ffi.NativeType;
import jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.FastIntMethodGenerator;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SigType;

public class FastLongMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final boolean ENABLED = FastLongMethodGenerator.getBooleanProperty("jnr.ffi.fast-long.enabled", true);
    private static final int MAX_PARAMETERS = FastLongMethodGenerator.getMaximumFastLongParameters();
    private static final String[] signatures;
    private static final String[] methodNames;

    public FastLongMethodGenerator(BufferMethodGenerator bufgen) {
        super(bufgen);
    }

    String getInvokerMethodName(ResultType resultType, ParameterType[] parameterTypes, boolean ignoreErrno) {
        int parameterCount = parameterTypes.length;
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    String getInvokerSignature(int parameterCount, Class nativeIntType) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    Class getInvokerType() {
        return Long.TYPE;
    }

    public boolean isSupported(ResultType resultType, ParameterType[] parameterTypes, CallingConvention callingConvention) {
        int parameterCount = parameterTypes.length;
        if (!ENABLED) {
            return false;
        }
        if (callingConvention != CallingConvention.DEFAULT || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getCPU() != Platform.CPU.X86_64) {
            return false;
        }
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        for (ParameterType parameterType : parameterTypes) {
            if (FastLongMethodGenerator.isFastLongParameter(platform, parameterType)) continue;
            return false;
        }
        return FastLongMethodGenerator.isFastLongResult(platform, resultType);
    }

    static int getMaximumFastLongParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeL6", CallContext.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static boolean isFastLongType(Platform platform, SigType type2) {
        return FastIntMethodGenerator.isFastIntType(platform, type2) || type2.nativeType == NativeType.SLONG || type2.nativeType == NativeType.ULONG || type2.nativeType == NativeType.SLONGLONG || type2.nativeType == NativeType.ULONGLONG;
    }

    static boolean isFastLongResult(Platform platform, ResultType resultType) {
        return FastLongMethodGenerator.isFastLongType(platform, resultType) || resultType.nativeType == NativeType.VOID || resultType.nativeType == NativeType.ADDRESS && resultType.size() == 8;
    }

    static boolean isFastLongParameter(Platform platform, ParameterType type2) {
        return FastLongMethodGenerator.isFastLongType(platform, type2) || AsmUtil.isDelegate(type2) && type2.size() == 8;
    }

    static {
        methodNames = new String[]{"invokeL0", "invokeL1", "invokeL2", "invokeL3", "invokeL4", "invokeL5", "invokeL6"};
        signatures = new String[MAX_PARAMETERS + 1];
        for (int i2 = 0; i2 <= MAX_PARAMETERS; ++i2) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(CallContext.class)).append(CodegenUtils.ci(Long.TYPE));
            for (int n = 0; n < i2; ++n) {
                sb.append('J');
            }
            FastLongMethodGenerator.signatures[i2] = sb.append(")J").toString();
        }
    }
}

