/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AttrAssignTwoArgNode
extends AttrAssignNode {
    private Node arg1;
    private Node arg2;

    public AttrAssignTwoArgNode(ISourcePosition position, Node receiverNode, String name2, ArrayNode argsNode) {
        super(position, receiverNode, name2, argsNode);
        assert (argsNode.size() == 2) : "argsNode.size() is 2";
        this.arg1 = argsNode.get(0);
        this.arg2 = argsNode.get(1);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self, aBlock);
        IRubyObject param1 = this.arg1.interpret(runtime, context, self, aBlock);
        IRubyObject param2 = this.arg2.interpret(runtime, context, self, aBlock);
        assert (AttrAssignTwoArgNode.hasMetaClass(receiver2)) : AttrAssignTwoArgNode.receiverClassName(receiver2);
        CallSite callSite = this.selectCallSite(self, receiver2);
        callSite.call(context, self, receiver2, param1, param2);
        return param2;
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value2, Block aBlock, boolean checkArity) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self, aBlock);
        IRubyObject param1 = this.arg1.interpret(runtime, context, self, aBlock);
        IRubyObject param2 = this.arg2.interpret(runtime, context, self, aBlock);
        assert (AttrAssignTwoArgNode.hasMetaClass(receiver2)) : AttrAssignTwoArgNode.receiverClassName(receiver2);
        CallSite callSite = this.selectCallSite(self, receiver2);
        callSite.call(context, self, receiver2, param1, param2, value2);
        return runtime.getNil();
    }
}

