/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Fiber"})
public abstract class Fiber
extends RubyObject
implements ExecutionContext {
    private final Map<Object, IRubyObject> contextVariables = new WeakHashMap<Object, IRubyObject>();
    protected volatile Block block;
    protected volatile RubyThread parent;
    protected boolean root;
    protected volatile Fiber transferredFrom;
    protected volatile Fiber transferredTo;

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!(this.root || block != null && block.isGiven())) {
            throw runtime.newArgumentError("tried to create Proc object without a block");
        }
        this.block = block;
        this.parent = context.getThread();
        this.initFiber(context);
        return this;
    }

    public Fiber(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    protected abstract void initFiber(ThreadContext var1);

    protected abstract IRubyObject resumeOrTransfer(ThreadContext var1, IRubyObject var2, boolean var3);

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2);

    public abstract boolean isAlive();

    public boolean isRoot() {
        return this.root;
    }

    public Fiber makeRootFiber() {
        this.root = true;
        return this;
    }

    @JRubyMethod
    public IRubyObject resume(ThreadContext context) {
        return this.resumeOrTransfer(context, context.nil, false);
    }

    @JRubyMethod
    public IRubyObject resume(ThreadContext context, IRubyObject arg2) {
        return this.resumeOrTransfer(context, arg2, false);
    }

    @JRubyMethod(rest=true)
    public IRubyObject resume(ThreadContext context, IRubyObject[] args2) {
        return this.resumeOrTransfer(context, context.runtime.newArrayNoCopyLight(args2), false);
    }

    @JRubyMethod
    public IRubyObject transfer(ThreadContext context) {
        return this.resumeOrTransfer(context, context.nil, true);
    }

    @JRubyMethod
    public IRubyObject transfer(ThreadContext context, IRubyObject arg2) {
        return this.resumeOrTransfer(context, arg2, true);
    }

    @JRubyMethod(rest=true)
    public IRubyObject transfer(ThreadContext context, IRubyObject[] args2) {
        return this.resumeOrTransfer(context, context.runtime.newArrayNoCopyLight(args2), true);
    }

    @Override
    public Map<Object, IRubyObject> getContextVariables() {
        return this.contextVariables;
    }

    public Fiber getTransferredFrom() {
        return this.transferredFrom;
    }

    public void setTransferredFrom(Fiber transferredFrom) {
        this.transferredFrom = transferredFrom;
    }

    public Fiber getTransferredTo() {
        return this.transferredTo;
    }

    public void setTransferredTo(Fiber transferredTo) {
        this.transferredTo = transferredTo;
    }
}

