/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class CompiledMethod
extends JavaMethod
implements Cloneable,
PositionAware,
MethodArgs2 {
    protected Object $scriptObject;
    protected ISourcePosition position;
    protected String[] parameterList;

    protected CompiledMethod() {
    }

    protected void init(RubyModule implementationClass, Arity arity2, Visibility visibility, StaticScope staticScope, Object scriptObject, CallConfiguration callConfig, ISourcePosition position, String parameterDesc) {
        this.$scriptObject = scriptObject;
        this.position = position;
        this.parameterList = parameterDesc.split(";");
        super.init(implementationClass, arity2, visibility, staticScope, callConfig);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        return this.call(context, self, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
        return this.call(context, self, clazz, name2, arg2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self, clazz, name2, arg1, arg2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.call(context, self, clazz, name2, arg1, arg2, arg3, Block.NULL_BLOCK);
    }

    @Override
    public DynamicMethod dup() {
        try {
            CompiledMethod msm = (CompiledMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public String getFile() {
        return this.position.getFile();
    }

    @Override
    public int getLine() {
        return this.position.getStartLine();
    }

    @Override
    public String[] getParameterList() {
        return this.parameterList;
    }

    public Object getScriptObject() {
        return this.$scriptObject;
    }

    public static class LazyCompiledMethod
    extends DynamicMethod
    implements Cloneable,
    PositionAware,
    MethodArgs2 {
        private final String method;
        private final Arity arity;
        private final StaticScope scope;
        private final Object scriptObject;
        private MethodFactory factory;
        private DynamicMethod compiledMethod;
        private final ISourcePosition position;
        private final String parameterDesc;
        private final String[] parameterList;

        public LazyCompiledMethod(RubyModule implementationClass, String method2, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, ISourcePosition position, String parameterDesc, MethodFactory factory) {
            super(implementationClass, visibility, callConfig);
            this.method = method2;
            this.arity = arity2;
            this.scope = scope;
            this.scriptObject = scriptObject;
            this.factory = factory;
            this.position = position;
            this.parameterDesc = parameterDesc;
            this.parameterList = parameterDesc.split(";");
        }

        private synchronized void initializeMethod() {
            if (this.compiledMethod != null) {
                return;
            }
            this.compiledMethod = this.factory.getCompiledMethod(this.implementationClass, this.method, this.arity, this.visibility, this.scope, this.scriptObject, this.callConfig, this.position, this.parameterDesc);
            this.factory = null;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, arg0);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, arg0, arg1);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, arg0, arg1, arg2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, args2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, arg0, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, arg0, arg1, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, arg0, arg1, arg2, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name2, args2, block);
        }

        @Override
        public Arity getArity() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getArity();
        }

        @Override
        public CallConfiguration getCallConfig() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getCallConfig();
        }

        @Override
        public RubyModule getImplementationClass() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getImplementationClass();
        }

        @Override
        protected RubyModule getProtectedClass() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getProtectedClass();
        }

        @Override
        public DynamicMethod getRealMethod() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getRealMethod();
        }

        @Override
        public Visibility getVisibility() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getVisibility();
        }

        @Override
        public boolean isCallableFrom(IRubyObject caller2, CallType callType) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.isCallableFrom(caller2, callType);
        }

        @Override
        public boolean isNative() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.isNative();
        }

        @Override
        public void setCallConfig(CallConfiguration callConfig) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setCallConfig(callConfig);
        }

        @Override
        public void setImplementationClass(RubyModule implClass) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setImplementationClass(implClass);
        }

        @Override
        public void setVisibility(Visibility visibility) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setVisibility(visibility);
        }

        @Override
        public DynamicMethod dup() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.dup();
        }

        @Override
        public String getFile() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.position.getFile();
        }

        @Override
        public int getLine() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.position.getStartLine();
        }

        @Override
        public String[] getParameterList() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

