/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.MultipleAsgnBase;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReqdArgMultipleAsgnInstr
extends MultipleAsgnBase {
    private final int preArgsCount;
    private final int postArgsCount;

    public ReqdArgMultipleAsgnInstr(Variable result2, Operand array, int preArgsCount, int postArgsCount, int index2) {
        super(Operation.MASGN_REQD, result2, array, index2);
        this.preArgsCount = preArgsCount;
        this.postArgsCount = postArgsCount;
    }

    public ReqdArgMultipleAsgnInstr(Variable result2, Operand array, int index2) {
        this(result2, array, -1, -1, index2);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.array + ", " + this.index + ", " + this.preArgsCount + ", " + this.postArgsCount + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new ReqdArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), this.array.cloneForInlining(ii), this.preArgsCount, this.postArgsCount, this.index);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        RubyArray rubyArray = (RubyArray)this.array.retrieve(context, self, currDynScope, temp);
        int n = rubyArray.getLength();
        if (this.preArgsCount == -1) {
            return rubyArray.entry(this.index);
        }
        int remaining = n - this.preArgsCount;
        if (remaining <= this.index) {
            return context.nil;
        }
        return remaining > this.postArgsCount ? rubyArray.entry(n - this.postArgsCount + this.index) : rubyArray.entry(this.preArgsCount + this.index);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReqdArgMultipleAsgnInstr(this);
    }
}

