/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SetReturnAddressInstr
extends Instr
implements ResultInstr {
    private Label returnAddr;
    private Variable result;

    public SetReturnAddressInstr(Variable result2, Label l) {
        super(Operation.SET_RETADDR);
        assert (result2 != null) : "SetReturnAddressInstr result is null";
        this.returnAddr = l;
        this.result = result2;
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    public Label getReturnAddr() {
        return this.returnAddr;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.returnAddr};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
    }

    @Override
    public String toString() {
        return "" + this.result + " = " + this.returnAddr;
    }

    @Override
    public Instr cloneForInlinedScope(InlinerInfo ii) {
        return new SetReturnAddressInstr(ii.getRenamedVariable(this.result), ii.getRenamedLabel(this.returnAddr));
    }

    @Override
    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new SetReturnAddressInstr(ii.getRenamedVariable(this.result), this.returnAddr);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        return this.returnAddr;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SetReturnAddressInstr(this);
    }
}

