/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class MethodBlock
extends ContextAwareBlockBody {
    private final RubyMethod method;
    private final String filename;
    private final int line;

    public static Block createMethodBlock(ThreadContext context, IRubyObject self, DynamicScope dynamicScope, MethodBlock body) {
        RubyMethod method2 = body.method;
        RubyModule module = method2.getMethod().getImplementationClass();
        Frame frame = new Frame();
        frame.setKlazz(module);
        frame.setName(method2.getMethodName());
        frame.setSelf(method2.receiver(context));
        frame.setVisibility(method2.getMethod().getVisibility());
        Binding binding2 = new Binding(frame, module, dynamicScope, new BacktraceElement(method2.getMethodName(), body.getFile(), body.getLine()));
        return new Block(body, binding2);
    }

    public MethodBlock(RubyMethod method2, StaticScope staticScope) {
        super(staticScope, Arity.createArity((int)method2.arity().getLongValue()), 3);
        this.method = method2;
        String filename2 = method2.getFilename();
        if (filename2 == null) {
            filename2 = "(method)";
        }
        this.filename = filename2;
        this.line = method2.getLine();
    }

    public abstract IRubyObject callback(IRubyObject var1, IRubyObject var2, IRubyObject var3, Block var4);

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.yield(context, context.runtime.newArrayNoCopy(args2), null, null, true, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, context.runtime.newArrayNoCopy(args2), null, null, true, binding2, type2, block);
    }

    @Override
    protected Frame pre(ThreadContext context, RubyModule klass, Binding binding2) {
        return context.preYieldNoScope(binding2, klass);
    }

    @Override
    protected void post(ThreadContext context, Binding binding2, Visibility visibility, Frame lastFrame) {
        context.postYieldNoScope(lastFrame);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yield(context, null, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yield(context, context.runtime.newArrayNoCopyLight(arg0, arg1), null, null, true, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yield(context, context.runtime.newArrayNoCopyLight(arg0, arg1, arg2), null, null, true, binding2, type2);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, null, null, false, binding2, type2);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, value2, null, null, false, binding2, type2, block);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, self, klass, aValue, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2, Block block) {
        if (klass == null) {
            self = binding2.getSelf();
            binding2.getFrame().setSelf(self);
        }
        Frame lastFrame = this.pre(context, klass, binding2);
        while (true) {
            try {
                IRubyObject iRubyObject = this.callback(value2, this.method, self, block);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                try {
                    context.pollThreadEvents();
                    continue;
                    catch (JumpException.BreakJump bj) {
                        throw bj;
                    }
                }
                catch (JumpException.NextJump nj) {
                    IRubyObject iRubyObject = (IRubyObject)nj.getValue();
                    return iRubyObject;
                }
            }
            break;
        }
        finally {
            this.post(context, binding2, null, lastFrame);
        }
    }

    @Override
    public String getFile() {
        return this.filename;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public RubyMethod getMethod() {
        return this.method;
    }
}

