/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.InheritedCacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.runtime.opto.GenerationInvalidator;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.ObjectIdentityInvalidator;

public class OptoFactory {
    public static final Constructor invDynInvCompilerConstructor;
    public static final Constructor invDynCacheCompilerConstructor;

    public static InvocationCompiler newInvocationCompiler(BaseBodyCompiler bodyCompiler, SkinnyMethodAdapter method2) {
        if (invDynInvCompilerConstructor != null) {
            try {
                return (InvocationCompiler)invDynInvCompilerConstructor.newInstance(bodyCompiler, method2);
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException ie) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return new StandardInvocationCompiler(bodyCompiler, method2);
    }

    public static CacheCompiler newCacheCompiler(StandardASMCompiler scriptCompiler) {
        if (invDynCacheCompilerConstructor != null) {
            try {
                return (CacheCompiler)invDynCacheCompilerConstructor.newInstance(scriptCompiler);
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException ie) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return new InheritedCacheCompiler(scriptCompiler);
    }

    public static Invalidator newConstantInvalidator() {
        if (RubyInstanceConfig.JAVA_VERSION == 51 && RubyInstanceConfig.INVOKEDYNAMIC_CONSTANTS) {
            try {
                return (Invalidator)Class.forName("org.jruby.runtime.opto.SwitchPointInvalidator").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ObjectIdentityInvalidator();
    }

    public static Invalidator newMethodInvalidator(RubyModule module) {
        if (RubyInstanceConfig.JAVA_VERSION == 51 && RubyInstanceConfig.INVOKEDYNAMIC_INVOCATION_SWITCHPOINT) {
            try {
                return (Invalidator)Class.forName("org.jruby.runtime.opto.GenerationAndSwitchPointInvalidator").getConstructor(RubyModule.class).newInstance(module);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new GenerationInvalidator(module);
    }

    static {
        Constructor<?> invCompilerConstructor = null;
        if (RubyInstanceConfig.INVOKEDYNAMIC_INVOCATION) {
            try {
                Class<?> compiler = Class.forName("org.jruby.compiler.impl.InvokeDynamicInvocationCompiler");
                invCompilerConstructor = compiler.getConstructor(BaseBodyCompiler.class, SkinnyMethodAdapter.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        invDynInvCompilerConstructor = invCompilerConstructor;
        Constructor<?> cacheCompilerConstructor = null;
        if (RubyInstanceConfig.INVOKEDYNAMIC_CACHE) {
            try {
                Class<?> compiler = Class.forName("org.jruby.compiler.impl.InvokeDynamicCacheCompiler");
                cacheCompilerConstructor = compiler.getConstructor(StandardASMCompiler.class);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        invDynCacheCompilerConstructor = cacheCompilerConstructor;
    }
}

