/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.file.FileComponent;
import org.apache.servicemix.file.FileEndpointType;
import org.apache.servicemix.util.FileUtil;

public class FileSenderEndpoint
extends ProviderEndpoint
implements FileEndpointType {
    private File directory;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    @Deprecated
    private String tempFilePrefix = "servicemix-";
    @Deprecated
    private String tempFileSuffix = ".xml";
    private boolean autoCreateDirectory = true;
    private boolean append = false;
    private boolean overwrite;

    public FileSenderEndpoint() {
    }

    public FileSenderEndpoint(FileComponent component, ServiceEndpoint endpoint) {
        super((DefaultComponent)component, endpoint);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.directory == null) {
            throw new DeploymentException("You must specify the directory property");
        }
        if (this.isAutoCreateDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new DeploymentException("The directory property must be a directory but was: " + this.directory);
        }
        if (this.isOverwrite() && this.isAppend()) {
            throw new DeploymentException("You can't have 'append' and 'overwrite' active at the same time.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        boolean success;
        String name;
        File newFile;
        OutputStream out;
        block33: {
            out = null;
            newFile = null;
            name = null;
            String writeTempName = null;
            success = false;
            try {
                name = this.marshaler.getOutputName(exchange, in);
                if (name == null) {
                    newFile = File.createTempFile("" + System.currentTimeMillis(), "tmp", this.directory);
                } else {
                    newFile = new File(this.directory, name);
                    if (newFile.exists()) {
                        if (this.isOverwrite()) {
                            newFile.delete();
                        } else if (!this.isAppend()) {
                            newFile = null;
                            throw new IOException("Can not write " + name + " : file already exists and overwrite has not been enabled");
                        }
                    }
                    writeTempName = this.marshaler.getTempOutputName(exchange, in) != null ? this.marshaler.getTempOutputName(exchange, in) : name;
                    newFile = new File(this.directory, writeTempName);
                }
                if (!newFile.getParentFile().exists() && this.isAutoCreateDirectory()) {
                    newFile.getParentFile().mkdirs();
                }
                logger.debug("Writing to file: {}", (Object)newFile.getCanonicalPath());
                out = new BufferedOutputStream(new FileOutputStream(newFile, this.append));
                this.marshaler.writeMessage(exchange, in, out, name);
                success = true;
                Object var9_8 = null;
                if (out == null) break block33;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                    }
                }
                if (success) {
                    if (name == null || name.equals(newFile.getName())) throw throwable;
                    if (this.isAppend()) {
                        File targetFile = new File(this.directory, name);
                        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(newFile));
                        out = new BufferedOutputStream(new FileOutputStream(targetFile, this.append));
                        FileUtil.copyInputStream((InputStream)bis, (OutputStream)out);
                        Object var14_17 = null;
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                        }
                        if (newFile.delete()) throw throwable;
                        throw new IOException("File " + newFile.getName() + " could not be deleted...");
                        {
                            catch (IOException ioex) {
                                logger.error("Unable to append to file {}", (Object)targetFile.getName(), (Object)ioex);
                                Object var14_18 = null;
                                try {
                                    out.close();
                                }
                                catch (IOException e) {
                                    logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                                }
                                if (newFile.delete()) throw throwable;
                                throw new IOException("File " + newFile.getName() + " could not be deleted...");
                            }
                        }
                        catch (Throwable throwable2) {
                            Object var14_19 = null;
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                            }
                            if (newFile.delete()) throw throwable2;
                            throw new IOException("File " + newFile.getName() + " could not be deleted...");
                        }
                    }
                    if (newFile.renameTo(new File(this.directory, name))) throw throwable;
                    throw new IOException("File " + newFile.getName() + " could not be renamed to " + name);
                }
                if (newFile != null) {
                    logger.error("An error occured while writing file {}, deleting the invalid file", (Object)newFile.getCanonicalPath());
                    if (newFile.delete()) throw throwable;
                    logger.warn("Unable to delete file {} after an error had occured", (Object)newFile.getCanonicalPath());
                    throw throwable;
                } else {
                    logger.error("An error occured while creating file or creating name of this file");
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
            }
        }
        if (success) {
            if (name == null || name.equals(newFile.getName())) return;
            if (this.isAppend()) {
                File targetFile = new File(this.directory, name);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(newFile));
                out = new BufferedOutputStream(new FileOutputStream(targetFile, this.append));
                FileUtil.copyInputStream((InputStream)bis, (OutputStream)out);
                Object var14_14 = null;
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                }
                if (newFile.delete()) return;
                throw new IOException("File " + newFile.getName() + " could not be deleted...");
                {
                    catch (IOException ioex) {
                        logger.error("Unable to append to file {}", (Object)targetFile.getName(), (Object)ioex);
                        Object var14_15 = null;
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                        }
                        if (newFile.delete()) return;
                        throw new IOException("File " + newFile.getName() + " could not be deleted...");
                    }
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error("Caught exception while closing stream on error: {}", (Object)e, (Object)e);
                    }
                    if (newFile.delete()) throw throwable;
                    throw new IOException("File " + newFile.getName() + " could not be deleted...");
                }
            }
            if (newFile.renameTo(new File(this.directory, name))) return;
            throw new IOException("File " + newFile.getName() + " could not be renamed to " + name);
        }
        if (newFile != null) {
            logger.error("An error occured while writing file {}, deleting the invalid file", (Object)newFile.getCanonicalPath());
            if (newFile.delete()) return;
            logger.warn("Unable to delete file {} after an error had occured", (Object)newFile.getCanonicalPath());
            return;
        }
        logger.error("An error occured while creating file or creating name of this file");
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        super.processInOut(exchange, in, out);
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    @Deprecated
    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
    }

    @Deprecated
    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    @Deprecated
    public void setTempFileSuffix(String tempFileSuffix) {
        this.tempFileSuffix = tempFileSuffix;
    }

    @Deprecated
    public String getTempFileSuffix() {
        return this.tempFileSuffix;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }
}

