/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.management.MBeanServer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.servicemix.common.security.KeystoreManager;
import org.apache.servicemix.http.ContextManager;
import org.apache.servicemix.http.HttpBridgeServlet;
import org.apache.servicemix.http.HttpConfiguration;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.http.jetty.JaasUserRealm;
import org.apache.servicemix.http.jetty.ServiceMixSslSocketConnector;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class JettyContextManager
implements ContextManager {
    private final Logger logger = LoggerFactory.getLogger(JettyContextManager.class);
    private Map<String, Server> servers;
    private HttpConfiguration configuration;
    private QueuedThreadPool threadPool;
    private Map<String, SslParameters> sslParams;
    private MBeanServer mBeanServer;
    private MBeanContainer mbeanContainer;

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public void init() throws Exception {
        if (this.configuration == null) {
            this.configuration = new HttpConfiguration();
        }
        if (this.mBeanServer != null && !this.configuration.isManaged() && this.configuration.isJettyManagement()) {
            this.mbeanContainer = new MBeanContainer(this.mBeanServer);
        }
        this.servers = new HashMap<String, Server>();
        this.sslParams = new HashMap<String, SslParameters>();
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setMaxThreads(this.configuration.getJettyThreadPoolSize());
        this.threadPool = qtp;
    }

    public void shutDown() throws Exception {
        this.stop();
    }

    public void start() throws Exception {
        this.threadPool.start();
        for (Server server : this.servers.values()) {
            server.start();
        }
    }

    public void stop() throws Exception {
        for (Server server : this.servers.values()) {
            server.stop();
        }
        for (Server server : this.servers.values()) {
            server.join();
            Connector[] connectors = server.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (!(connectors[i] instanceof AbstractConnector)) continue;
                ((AbstractConnector)connectors[i]).join();
            }
        }
        this.threadPool.stop();
    }

    public synchronized Object createContext(String strUrl, HttpProcessor processor) throws Exception {
        URL url = new URL(strUrl);
        Server server = this.getServer(url);
        if (server == null) {
            server = this.createServer(url, processor.getSsl());
        } else {
            SslParameters ssl = this.sslParams.get(this.getKey(url));
            if (ssl != null && !ssl.equals(processor.getSsl())) {
                throw new Exception("An https server is already created on port " + url.getPort() + " but SSL parameters do not match");
            }
        }
        String path = url.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String pathSlash = path + "/";
        HandlerCollection handlerCollection = (HandlerCollection)server.getHandler();
        ContextHandlerCollection contexts = (ContextHandlerCollection)handlerCollection.getHandlers()[0];
        Handler[] handlers = contexts.getHandlers();
        if (handlers != null) {
            for (int i = 0; i < handlers.length; ++i) {
                ContextHandler h;
                String handlerPath;
                if (!(handlers[i] instanceof ContextHandler) || !(handlerPath = (h = (ContextHandler)handlers[i]).getContextPath() + "/").startsWith(pathSlash) && !pathSlash.startsWith(handlerPath)) continue;
                throw new Exception("The requested context for path '" + path + "' overlaps with an existing context for path: '" + h.getContextPath() + "'");
            }
        }
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath(path);
        ServletHolder holder = new ServletHolder();
        holder.setName("jbiServlet");
        holder.setClassName(HttpBridgeServlet.class.getName());
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.setServlets(new ServletHolder[]{holder});
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("jbiServlet");
        mapping.setPathSpec("/*");
        servletHandler.setServletMappings(new ServletMapping[]{mapping});
        if (processor.getAuthMethod() != null) {
            ConstraintSecurityHandler secHandler = new ConstraintSecurityHandler();
            ConstraintMapping constraintMapping = new ConstraintMapping();
            Constraint constraint = new Constraint();
            constraint.setAuthenticate(true);
            constraint.setRoles(new String[]{"*"});
            constraintMapping.setConstraint(constraint);
            constraintMapping.setPathSpec("/");
            secHandler.setConstraintMappings(new ConstraintMapping[]{constraintMapping});
            secHandler.setHandler((Handler)servletHandler);
            secHandler.setAuthMethod(processor.getAuthMethod());
            JaasUserRealm realm = new JaasUserRealm();
            if (this.configuration.getAuthenticationService() != null) {
                realm.setAuthenticationService(AuthenticationService.Proxy.create((Object)this.configuration.getAuthenticationService()));
            }
            secHandler.setLoginService((LoginService)realm);
            context.setSecurityHandler((SecurityHandler)secHandler);
        }
        context.setServletHandler(servletHandler);
        context.setAttribute("processor", (Object)processor);
        contexts.addHandler((Handler)context);
        servletHandler.initialize();
        context.start();
        return context;
    }

    public synchronized void remove(Object context) throws Exception {
        ((ContextHandler)context).stop();
        for (Server server : this.servers.values()) {
            HandlerCollection handlerCollection = (HandlerCollection)server.getHandler();
            ContextHandlerCollection contexts = (ContextHandlerCollection)handlerCollection.getHandlers()[0];
            Object[] handlers = contexts.getHandlers();
            if (handlers == null || handlers.length <= 0) continue;
            contexts.setHandlers((Handler[])LazyList.removeFromArray((Object[])handlers, (Object)context));
        }
    }

    protected Server getServer(URL url) {
        return this.servers.get(this.getKey(url));
    }

    protected String getKey(URL url) {
        String host = url.getHost();
        try {
            InetAddress addr = InetAddress.getByName(host);
            if (addr.isAnyLocalAddress()) {
                host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return url.getProtocol() + "://" + host + ":" + url.getPort();
    }

    protected Server createServer(URL url, SslParameters ssl) throws Exception {
        int serverGracefulTimeout;
        Connector connector;
        boolean isSsl = false;
        if (url.getProtocol().equals("https")) {
            if (ssl == null) {
                throw new IllegalArgumentException("https protocol required but no ssl parameters found");
            }
            isSsl = true;
        } else if (!url.getProtocol().equals("http")) {
            throw new UnsupportedOperationException("Protocol " + url.getProtocol() + " is not supported");
        }
        if (isSsl && ssl.isManaged()) {
            connector = this.setupManagerSslConnector(url, ssl);
        } else if (isSsl) {
            connector = this.setupSslConnector(url, ssl);
        } else {
            String connectorClassName = this.configuration.getJettyConnectorClassName();
            try {
                connector = (Connector)Class.forName(connectorClassName).newInstance();
            }
            catch (Exception e) {
                this.logger.warn("Could not create a jetty connector of class '{}'. Defaulting to {}", (Object)connectorClassName, (Object)HttpConfiguration.DEFAULT_JETTY_CONNECTOR_CLASS_NAME);
                this.logger.debug("Reason: {}", (Object)e.getMessage(), (Object)e);
                connector = (Connector)Class.forName(HttpConfiguration.DEFAULT_JETTY_CONNECTOR_CLASS_NAME).newInstance();
            }
        }
        connector.setHost(url.getHost());
        connector.setPort(url.getPort());
        connector.setMaxIdleTime(this.configuration.getConnectorMaxIdleTime());
        ((AbstractConnector)connector).setSoLingerTime(this.configuration.getSoLingerTime());
        Server server = new Server();
        server.setThreadPool((ThreadPool)new ThreadPoolWrapper());
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{contexts, new DisplayServiceHandler()});
        server.setHandler((Handler)handlers);
        this.servers.put(this.getKey(url), server);
        this.sslParams.put(this.getKey(url), isSsl ? ssl : null);
        if (this.mbeanContainer != null) {
            server.getContainer().addEventListener((Container.Listener)this.mbeanContainer);
        }
        if ((serverGracefulTimeout = this.configuration.getServerGracefulTimeout()) > 0) {
            server.setGracefulShutdown(serverGracefulTimeout);
            server.setStopAtShutdown(true);
        }
        server.start();
        return server;
    }

    private Connector setupSslConnector(URL url, SslParameters ssl) throws JBIException {
        String keyStorePassword;
        String keyStore = ssl.getKeyStore();
        if (keyStore == null && (keyStore = System.getProperty("javax.net.ssl.keyStore", "")) == null) {
            throw new IllegalArgumentException("keyStore or system property javax.net.ssl.keyStore must be set");
        }
        if (keyStore.startsWith("classpath:")) {
            try {
                String res = keyStore.substring(10);
                URL resurl = new ClassPathResource(res).getURL();
                keyStore = resurl.toString();
            }
            catch (IOException e) {
                throw new JBIException("Unable to find keystore " + keyStore, (Throwable)e);
            }
        }
        if ((keyStorePassword = ssl.getKeyStorePassword()) == null && (keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword")) == null) {
            throw new IllegalArgumentException("keyStorePassword or system property javax.net.ssl.keyStorePassword must be set");
        }
        SslSocketConnector sslConnector = new SslSocketConnector();
        sslConnector.setSslKeyManagerFactoryAlgorithm(ssl.getKeyManagerFactoryAlgorithm());
        sslConnector.setSslTrustManagerFactoryAlgorithm(ssl.getTrustManagerFactoryAlgorithm());
        sslConnector.setProtocol(ssl.getProtocol());
        sslConnector.setConfidentialPort(url.getPort());
        sslConnector.setPassword(ssl.getKeyStorePassword());
        sslConnector.setKeyPassword(ssl.getKeyPassword() != null ? ssl.getKeyPassword() : keyStorePassword);
        sslConnector.setKeystore(keyStore);
        sslConnector.setKeystoreType(ssl.getKeyStoreType());
        sslConnector.setNeedClientAuth(ssl.isNeedClientAuth());
        sslConnector.setWantClientAuth(ssl.isWantClientAuth());
        sslConnector.setTruststore(ssl.getTrustStore());
        if (ssl.getTrustStorePassword() != null) {
            sslConnector.setTrustPassword(ssl.getTrustStorePassword());
        }
        sslConnector.setTruststoreType(ssl.getTrustStoreType());
        SslSocketConnector connector = sslConnector;
        return connector;
    }

    private Connector setupManagerSslConnector(URL url, SslParameters ssl) {
        String keyStore = ssl.getKeyStore();
        if (keyStore == null) {
            throw new IllegalArgumentException("keyStore must be set");
        }
        ServiceMixSslSocketConnector sslConnector = new ServiceMixSslSocketConnector();
        sslConnector.setSslKeyManagerFactoryAlgorithm(ssl.getKeyManagerFactoryAlgorithm());
        sslConnector.setSslTrustManagerFactoryAlgorithm(ssl.getTrustManagerFactoryAlgorithm());
        sslConnector.setProtocol(ssl.getProtocol());
        sslConnector.setConfidentialPort(url.getPort());
        sslConnector.setKeystore(keyStore);
        sslConnector.setKeyAlias(ssl.getKeyAlias());
        sslConnector.setNeedClientAuth(ssl.isNeedClientAuth());
        sslConnector.setWantClientAuth(ssl.isWantClientAuth());
        sslConnector.setKeystoreManager(KeystoreManager.Proxy.create((Object)this.getConfiguration().getKeystoreManager()));
        sslConnector.setTruststore(ssl.getTrustStore());
        if (ssl.getTrustStorePassword() != null) {
            sslConnector.setTrustPassword(ssl.getTrustStorePassword());
        }
        sslConnector.setTruststoreType(ssl.getTrustStoreType());
        ServiceMixSslSocketConnector connector = sslConnector;
        return connector;
    }

    public HttpConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HttpConfiguration configuration) {
        this.configuration = configuration;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public HttpProcessor getMainProcessor() {
        throw new IllegalStateException("ServerManager is not managed");
    }

    protected class ThreadPoolWrapper
    extends AbstractLifeCycle
    implements ThreadPool {
        protected ThreadPoolWrapper() {
        }

        public boolean dispatch(Runnable job) {
            JettyContextManager.this.logger.debug("Dispatching job: {}", (Object)job);
            return JettyContextManager.this.threadPool.dispatch(job);
        }

        public int getIdleThreads() {
            return JettyContextManager.this.threadPool.getIdleThreads();
        }

        public int getThreads() {
            return JettyContextManager.this.threadPool.getThreads();
        }

        public void join() throws InterruptedException {
        }

        public boolean isLowOnThreads() {
            return JettyContextManager.this.threadPool.isLowOnThreads();
        }
    }

    protected class DisplayServiceHandler
    extends AbstractHandler {
        protected DisplayServiceHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (response.isCommitted() || AbstractHttpConnection.getCurrentConnection().getRequest().isHandled()) {
                return;
            }
            String method = request.getMethod();
            if (!method.equals("GET") || !request.getRequestURI().equals("/")) {
                response.sendError(404);
                return;
            }
            response.setStatus(404);
            response.setContentType("text/html");
            ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
            String uri = request.getRequestURI();
            uri = StringUtil.replace((String)uri, (String)"<", (String)"&lt;");
            uri = StringUtil.replace((String)uri, (String)">", (String)"&gt;");
            writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
            writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
            writer.write("No service matched or handled this request.<BR>");
            writer.write("Known services are: <ul>");
            for (String serverUri : JettyContextManager.this.servers.keySet()) {
                Server server = (Server)JettyContextManager.this.servers.get(serverUri);
                Handler[] handlers = server.getChildHandlersByClass(ContextHandler.class);
                for (int i = 0; handlers != null && i < handlers.length; ++i) {
                    if (!(handlers[i] instanceof ContextHandler)) continue;
                    ContextHandler context = (ContextHandler)handlers[i];
                    StringBuffer sb = new StringBuffer();
                    sb.append(serverUri);
                    if (!context.getContextPath().startsWith("/")) {
                        sb.append("/");
                    }
                    sb.append(context.getContextPath());
                    if (!context.getContextPath().endsWith("/")) {
                        sb.append("/");
                    }
                    if (context.isStarted()) {
                        writer.write("<li><a href=\"");
                        writer.write(sb.toString());
                        writer.write("?wsdl\">");
                        writer.write(sb.toString());
                        writer.write("</a></li>\n");
                        continue;
                    }
                    writer.write("<li>");
                    writer.write(sb.toString());
                    writer.write(" [Stopped]</li>\n");
                }
            }
            for (int i = 0; i < 10; ++i) {
                writer.write("\n<!-- Padding for IE                  -->");
            }
            writer.write("\n</BODY>\n</HTML>\n");
            writer.flush();
            response.setContentLength(writer.size());
            ServletOutputStream out = response.getOutputStream();
            writer.writeTo((OutputStream)out);
            out.close();
        }
    }
}

