/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v9;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v9.BaseCommandMarshaller;

public class DestinationInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 8;
    }

    @Override
    public DataStructure createObject() {
        return new DestinationInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        DestinationInfo info2 = (DestinationInfo)o;
        info2.setConnectionId((ConnectionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setDestination((ActiveMQDestination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setOperationType(dataIn.readByte());
        info2.setTimeout(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        if (bs.readBoolean()) {
            int size2 = dataIn.readShort();
            BrokerId[] value = new BrokerId[size2];
            for (int i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info2.setBrokerPath(value);
        } else {
            info2.setBrokerPath(null);
        }
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        DestinationInfo info2 = (DestinationInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getConnectionId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getDestination(), bs);
        rc += this.tightMarshalLong1(wireFormat, info2.getTimeout(), bs);
        return (rc += this.tightMarshalObjectArray1(wireFormat, info2.getBrokerPath(), bs)) + 1;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        DestinationInfo info2 = (DestinationInfo)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getConnectionId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getDestination(), dataOut, bs);
        dataOut.writeByte(info2.getOperationType());
        this.tightMarshalLong2(wireFormat, info2.getTimeout(), dataOut, bs);
        this.tightMarshalObjectArray2(wireFormat, info2.getBrokerPath(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        DestinationInfo info2 = (DestinationInfo)o;
        info2.setConnectionId((ConnectionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setDestination((ActiveMQDestination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setOperationType(dataIn.readByte());
        info2.setTimeout(this.looseUnmarshalLong(wireFormat, dataIn));
        if (dataIn.readBoolean()) {
            int size2 = dataIn.readShort();
            BrokerId[] value = new BrokerId[size2];
            for (int i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info2.setBrokerPath(value);
        } else {
            info2.setBrokerPath(null);
        }
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        DestinationInfo info2 = (DestinationInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getConnectionId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getDestination(), dataOut);
        dataOut.writeByte(info2.getOperationType());
        this.looseMarshalLong(wireFormat, info2.getTimeout(), dataOut);
        this.looseMarshalObjectArray(wireFormat, info2.getBrokerPath(), dataOut);
    }
}

