/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.transport;

import java.util.AbstractList;
import java.util.List;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.Transfer;
import org.apache.qpid.proton.codec.AbstractDescribedType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.codec.EncoderImpl;

public final class TransferType
extends AbstractDescribedType<Transfer, List>
implements DescribedTypeConstructor<Transfer> {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(20L), Symbol.valueOf("amqp:transfer:list")};
    private static final UnsignedLong DESCRIPTOR = UnsignedLong.valueOf(20L);

    private TransferType(EncoderImpl encoder) {
        super(encoder);
    }

    @Override
    public UnsignedLong getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected List wrap(Transfer val) {
        return new TransferWrapper(val);
    }

    @Override
    public Transfer newInstance(Object described) {
        List l = (List)described;
        Transfer o = new Transfer();
        if (l.isEmpty()) {
            throw new DecodeException("The handle field cannot be omitted");
        }
        switch (11 - l.size()) {
            case 0: {
                Boolean batchable = (Boolean)l.get(10);
                o.setBatchable(batchable == null ? false : batchable);
            }
            case 1: {
                Boolean aborted = (Boolean)l.get(9);
                o.setAborted(aborted == null ? false : aborted);
            }
            case 2: {
                Boolean resume2 = (Boolean)l.get(8);
                o.setResume(resume2 == null ? false : resume2);
            }
            case 3: {
                o.setState((DeliveryState)l.get(7));
            }
            case 4: {
                UnsignedByte receiverSettleMode = (UnsignedByte)l.get(6);
                o.setRcvSettleMode(receiverSettleMode == null ? null : ReceiverSettleMode.values()[receiverSettleMode.intValue()]);
            }
            case 5: {
                Boolean more = (Boolean)l.get(5);
                o.setMore(more == null ? false : more);
            }
            case 6: {
                o.setSettled((Boolean)l.get(4));
            }
            case 7: {
                o.setMessageFormat((UnsignedInteger)l.get(3));
            }
            case 8: {
                o.setDeliveryTag((Binary)l.get(2));
            }
            case 9: {
                o.setDeliveryId((UnsignedInteger)l.get(1));
            }
            case 10: {
                o.setHandle((UnsignedInteger)l.get(0));
            }
        }
        return o;
    }

    @Override
    public Class<Transfer> getTypeClass() {
        return Transfer.class;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        TransferType type = new TransferType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }

    public static class TransferWrapper
    extends AbstractList {
        private Transfer _transfer;

        public TransferWrapper(Transfer transfer) {
            this._transfer = transfer;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this._transfer.getHandle();
                }
                case 1: {
                    return this._transfer.getDeliveryId();
                }
                case 2: {
                    return this._transfer.getDeliveryTag();
                }
                case 3: {
                    return this._transfer.getMessageFormat();
                }
                case 4: {
                    return this._transfer.getSettled();
                }
                case 5: {
                    return this._transfer.getMore();
                }
                case 6: {
                    return this._transfer.getRcvSettleMode() == null ? null : this._transfer.getRcvSettleMode().getValue();
                }
                case 7: {
                    return this._transfer.getState();
                }
                case 8: {
                    return this._transfer.getResume();
                }
                case 9: {
                    return this._transfer.getAborted();
                }
                case 10: {
                    return this._transfer.getBatchable();
                }
            }
            throw new IllegalStateException("Unknown index " + index);
        }

        @Override
        public int size() {
            return this._transfer.getBatchable() ? 11 : (this._transfer.getAborted() ? 10 : (this._transfer.getResume() ? 9 : (this._transfer.getState() != null ? 8 : (this._transfer.getRcvSettleMode() != null ? 7 : (this._transfer.getMore() ? 6 : (this._transfer.getSettled() != null ? 5 : (this._transfer.getMessageFormat() != null ? 4 : (this._transfer.getDeliveryTag() != null ? 3 : (this._transfer.getDeliveryId() != null ? 2 : 1)))))))));
        }
    }
}

