/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.driver.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.driver.impl.DriverImpl;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportFactory;

class ConnectorImpl<C>
implements Connector<C> {
    private static int DEFAULT_BUFFER_SIZE = 65536;
    private static int readBufferSize = Integer.getInteger("pn.receive_buffer_size", DEFAULT_BUFFER_SIZE);
    private static int writeBufferSize = Integer.getInteger("pn.send_buffer_size", DEFAULT_BUFFER_SIZE);
    private final DriverImpl _driver;
    private final Listener<C> _listener;
    private final SocketChannel _channel;
    private final Logger _logger = Logger.getLogger("proton.driver");
    private C _context;
    private Connection _connection;
    private Transport _transport = null;
    private SelectionKey _key;
    private ConnectorState _state = ConnectorState.UNINITIALIZED;
    private ByteBuffer _readBuffer = ByteBuffer.allocate(readBufferSize);
    private ByteBuffer _writeBuffer = ByteBuffer.allocate(writeBufferSize);
    private boolean _readPending;

    ConnectorImpl(DriverImpl driver, Listener<C> listener, SocketChannel c, C context, SelectionKey key) {
        this._driver = driver;
        this._listener = listener;
        this._channel = c;
        this._context = context;
        this._key = key;
    }

    void selected() {
        this._readPending = true;
    }

    @Override
    public void process() throws IOException {
        if (this._channel.isOpen() && this._channel.finishConnect()) {
            if (this._readPending) {
                this.read();
                this._readPending = false;
                if (this.isClosed()) {
                    return;
                }
            }
            this.write();
        }
    }

    void read() throws IOException {
        int bytesRead = 0;
        while ((bytesRead = this._channel.read(this._readBuffer)) > 0) {
            this._readBuffer.flip();
            int consumed = this._transport.input(this._readBuffer.array(), this._readBuffer.position(), this._readBuffer.limit());
            this._readBuffer.position(consumed == -1 ? this._readBuffer.limit() : consumed);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "consumed " + consumed + " bytes, " + this._readBuffer.remaining() + " available");
            }
            this._readBuffer.compact();
        }
        if (bytesRead == -1) {
            this.close();
        }
    }

    void write() throws IOException {
        int interest = this._key.interestOps();
        int start2 = this._writeBuffer.position();
        boolean done = false;
        while (!done) {
            int produced = this._transport.output(this._writeBuffer.array(), this._writeBuffer.position(), this._writeBuffer.remaining());
            this._writeBuffer.position(this._writeBuffer.position() + produced);
            this._writeBuffer.flip();
            int wrote = this._channel.write(this._writeBuffer);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "wrote " + wrote + " bytes, " + this._writeBuffer.remaining() + " remaining");
            }
            this._writeBuffer.compact();
            if (this._writeBuffer.position() > 0) {
                interest |= 4;
                done = true;
                continue;
            }
            interest &= 0xFFFFFFFB;
            done = start2 == 0 && produced < this._writeBuffer.capacity();
            start2 = 0;
        }
        this._key.interestOps(interest);
    }

    @Override
    public Listener<C> listener() {
        return this._listener;
    }

    @Override
    public Sasl sasl() {
        if (this._transport != null) {
            return this._transport.sasl();
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
        this._transport = TransportFactory.getDefaultTransportFactory().transport(this._connection);
    }

    @Override
    public C getContext() {
        return this._context;
    }

    @Override
    public void setContext(C context) {
        this._context = context;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            try {
                this.write();
                this._channel.close();
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Exception when closing connection", e);
            }
        }
    }

    @Override
    public boolean isClosed() {
        boolean result = !this._channel.isOpen() || !this._channel.isConnected();
        return result;
    }

    @Override
    public void destroy() {
        this.close();
        this._driver.removeConnector(this);
    }

    static enum ConnectorState {
        UNINITIALIZED,
        OPENED,
        EOS,
        CLOSED;

    }
}

