/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.ssl.ByteHolder;
import org.apache.qpid.proton.engine.impl.ssl.BytePipeline;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngine;
import org.apache.qpid.proton.engine.impl.ssl.SslTransportWrapper;

public class SimpleSslTransportWrapper
implements SslTransportWrapper {
    private static final Logger _logger = Logger.getLogger(SimpleSslTransportWrapper.class.getName());
    private static final int APPLICATION_BUFFER_EXTRA = 50;
    private final TransportInput _underlyingInput;
    private final TransportOutput _underlyingOutput;
    private ProtonSslEngine _sslEngine;
    private ByteHolder _clearOutputHolder;
    private ByteHolder _encodedOutputHolder;
    private ByteHolder _decodedInputHolder;
    private final BytePipeline _encodedLeftoversPipeline = new BytePipeline();
    private String _cipherName;
    private String _protocolName;

    SimpleSslTransportWrapper(ProtonSslEngine sslEngine, TransportInput underlyingInput, TransportOutput underlyingOutput) {
        this._underlyingInput = underlyingInput;
        this._underlyingOutput = underlyingOutput;
        this._sslEngine = sslEngine;
        this.createByteHolders();
    }

    private void createByteHolders() {
        int appBufferMax = this._sslEngine.getApplicationBufferSize();
        int packetBufferMax = this._sslEngine.getPacketBufferSize();
        this._clearOutputHolder = new ByteHolder(appBufferMax + 50);
        this._decodedInputHolder = new ByteHolder(appBufferMax + 50);
        this._decodedInputHolder.prepareToRead();
        this._encodedOutputHolder = new ByteHolder(packetBufferMax);
        this._encodedOutputHolder.prepareToRead();
    }

    @Override
    public int input(byte[] encodedBytes, int offset, int size2) {
        int initialSizeOfEncodedLeftovers = this._encodedLeftoversPipeline.getSize();
        ByteBuffer oldPlusNewEncodedByteBuffer = this._encodedLeftoversPipeline.appendAndClear(encodedBytes, offset, size2);
        if (!this._decodedInputHolder.readInto(this._underlyingInput)) {
            return 0;
        }
        try {
            boolean allAcceptedByUnderlyingInput;
            SSLEngineResult.Status sslResultStatus;
            SSLEngineResult.HandshakeStatus handshakeStatus;
            boolean keepLooping = true;
            int totalBytesDecoded = 0;
            do {
                SSLEngineResult result = this._sslEngine.unwrap(oldPlusNewEncodedByteBuffer, this._decodedInputHolder.prepareToWrite());
                this._decodedInputHolder.prepareToRead();
                this.runDelegatedTasks(result);
                this.updateCipherAndProtocolName(result);
                this.logEngineClientModeAndResult(result, "input");
                sslResultStatus = result.getStatus();
                handshakeStatus = result.getHandshakeStatus();
                if (sslResultStatus == SSLEngineResult.Status.OK) {
                    totalBytesDecoded += result.bytesConsumed();
                } else if (sslResultStatus == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    this._encodedLeftoversPipeline.set(oldPlusNewEncodedByteBuffer, totalBytesDecoded);
                } else {
                    throw new IllegalStateException("Unexpected SSL Engine state " + (Object)((Object)sslResultStatus));
                }
                allAcceptedByUnderlyingInput = true;
                if (result.bytesProduced() <= 0) continue;
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    _logger.warning("WARN unexpectedly produced bytes for the underlying input when handshaking");
                }
                allAcceptedByUnderlyingInput = this._decodedInputHolder.readInto(this._underlyingInput);
            } while (keepLooping = handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && sslResultStatus != SSLEngineResult.Status.BUFFER_UNDERFLOW && allAcceptedByUnderlyingInput);
            int newEncodedLeftovers = this._encodedLeftoversPipeline.getSize();
            int sizeToReportConsumed = totalBytesDecoded + newEncodedLeftovers - initialSizeOfEncodedLeftovers;
            return sizeToReportConsumed;
        }
        catch (SSLException e) {
            throw new TransportException("Problem during input. useClientMode: " + this._sslEngine.getUseClientMode(), e);
        }
    }

    @Override
    public int output(byte[] destination, int offset, int size2) {
        try {
            int numberOfBytesInClearOutputHolder;
            int totalBytesWrittenToDestination = this._encodedOutputHolder.readInto(destination, offset, size2);
            if (totalBytesWrittenToDestination == size2) {
                return size2;
            }
            boolean keepLooping = true;
            while (!this._clearOutputHolder.hasSpace() || (numberOfBytesInClearOutputHolder = this._clearOutputHolder.writeOutputFrom(this._underlyingOutput)) != 0) {
                int availableDestinationSize = size2 - totalBytesWrittenToDestination;
                boolean wrappingIntoEncodedOutputHolder = availableDestinationSize < this._sslEngine.getPacketBufferSize();
                ByteBuffer sslWrapDst = wrappingIntoEncodedOutputHolder ? this._encodedOutputHolder.prepareToWrite() : ByteBuffer.wrap(destination, offset + totalBytesWrittenToDestination, availableDestinationSize);
                SSLEngineResult result = this._sslEngine.wrap(this._clearOutputHolder.prepareToRead(), sslWrapDst);
                this.logEngineClientModeAndResult(result, "output");
                this._clearOutputHolder.prepareToWrite();
                SSLEngineResult.Status sslResultStatus = result.getStatus();
                if (sslResultStatus == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    throw new IllegalStateException("Insufficient space to perform wrap into encoded output buffer that has " + sslWrapDst.remaining() + " remaining bytes. wrappingIntoEncodedOutputHolder=" + wrappingIntoEncodedOutputHolder);
                }
                if (sslResultStatus != SSLEngineResult.Status.OK) {
                    throw new RuntimeException("Unexpected SSLEngineResult status " + (Object)((Object)sslResultStatus));
                }
                this.runDelegatedTasks(result);
                this.updateCipherAndProtocolName(result);
                int numberOfNewlyEncodedBytesWritten = Math.min(availableDestinationSize, result.bytesProduced());
                if (wrappingIntoEncodedOutputHolder) {
                    this._encodedOutputHolder.prepareToRead();
                    this._encodedOutputHolder.readInto(destination, offset + totalBytesWrittenToDestination, numberOfNewlyEncodedBytesWritten);
                }
                if (keepLooping = result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && (totalBytesWrittenToDestination += numberOfNewlyEncodedBytesWritten) < size2) continue;
            }
            return totalBytesWrittenToDestination;
        }
        catch (SSLException e) {
            throw new TransportException("Problem during output. useClientMode: " + this._sslEngine.getUseClientMode(), e);
        }
    }

    @Override
    public String getCipherName() {
        return this._cipherName;
    }

    @Override
    public String getProtocolName() {
        return this._protocolName;
    }

    private void updateCipherAndProtocolName(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this._cipherName = this._sslEngine.getCipherSuite();
            this._protocolName = this._sslEngine.getProtocol();
        }
    }

    private void runDelegatedTasks(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = this._sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = this._sslEngine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new RuntimeException("handshake shouldn't need additional tasks");
            }
        }
    }

    private void logEngineClientModeAndResult(SSLEngineResult result, String direction) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "useClientMode = " + this._sslEngine.getUseClientMode() + " direction = " + direction + " " + this.resultToString(result));
        }
    }

    private String resultToString(SSLEngineResult result) {
        return "[SSLEngineResult status = " + (Object)((Object)result.getStatus()) + " handshakeStatus = " + (Object)((Object)result.getHandshakeStatus()) + " bytesConsumed = " + result.bytesConsumed() + " bytesProduced = " + result.bytesProduced() + "]";
    }
}

