/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.Terminal;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.shell.osgi.BundlesCommandOptional;
import org.apache.karaf.shell.osgi.Util;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="osgi", name="headers", description="Displays OSGi headers of a given bundle.")
public class Headers
extends BundlesCommandOptional {
    protected static final String BUNDLE_PREFIX = "Bundle-";
    protected static final String PACKAGE_SUFFFIX = "-Package";
    protected static final String SERVICE_SUFFIX = "-Service";
    protected static final String IMPORT_PACKAGES_ATTRIB = "Import-Package";
    protected static final String REQUIRE_BUNDLE_ATTRIB = "Require-Bundle";
    private ServiceReference ref;
    private PackageAdmin admin;
    @Option(name="--indent", description="Indentation method")
    int indent = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        this.ref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (this.ref == null) {
            System.out.println("PackageAdmin service is unavailable.");
            return;
        }
        try {
            this.admin = (PackageAdmin)this.getBundleContext().getService(this.ref);
            if (this.admin == null) {
                System.out.println("PackageAdmin service is unavailable.");
                return;
            }
            if (bundles == null) {
                Bundle[] allBundles = this.getBundleContext().getBundles();
                for (int i = 0; i < allBundles.length; ++i) {
                    this.printHeaders(allBundles[i]);
                }
            } else {
                for (Bundle bundle : bundles) {
                    this.printHeaders(bundle);
                }
            }
        }
        finally {
            this.getBundleContext().ungetService(this.ref);
        }
    }

    protected void printHeaders(Bundle bundle) {
        String title = Util.getBundleName(bundle);
        System.out.println("\n" + title);
        System.out.println(Util.getUnderlineString(title));
        if (this.indent == 0) {
            Dictionary dict = bundle.getHeaders();
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object k = keys.nextElement();
                Object v = dict.get(k);
                System.out.println(k + " = " + Util.getValueString(v));
            }
        } else {
            System.out.println(this.generateFormattedOutput(bundle));
        }
    }

    protected String generateFormattedOutput(Bundle bundle) {
        StringBuilder output = new StringBuilder();
        HashMap otherAttribs = new HashMap();
        HashMap bundleAttribs = new HashMap();
        HashMap serviceAttribs = new HashMap();
        HashMap packagesAttribs = new HashMap();
        Dictionary dict = bundle.getHeaders();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            Object v = dict.get(k);
            if (k.startsWith(BUNDLE_PREFIX)) {
                bundleAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(SERVICE_SUFFIX)) {
                serviceAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(PACKAGE_SUFFFIX)) {
                packagesAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(REQUIRE_BUNDLE_ATTRIB)) {
                packagesAttribs.put(k, v);
                continue;
            }
            otherAttribs.put(k, v);
        }
        for (Map.Entry e : otherAttribs.entrySet()) {
            output.append(String.format("%s = %s\n", e.getKey(), Util.getValueString(e.getValue())));
        }
        if (otherAttribs.size() > 0) {
            output.append('\n');
        }
        for (Map.Entry e : bundleAttribs.entrySet()) {
            output.append(String.format("%s = %s\n", e.getKey(), Util.getValueString(e.getValue())));
        }
        if (bundleAttribs.size() > 0) {
            output.append('\n');
        }
        for (Map.Entry e : serviceAttribs.entrySet()) {
            output.append((String)e.getKey());
            output.append(" = \n");
            this.formatHeader(Util.getValueString(e.getValue()), null, output, this.indent);
            output.append("\n");
        }
        if (serviceAttribs.size() > 0) {
            output.append('\n');
        }
        HashMap<String, ClauseFormatter> formatters = new HashMap<String, ClauseFormatter>();
        formatters.put(REQUIRE_BUNDLE_ATTRIB, new ClauseFormatter(){

            public void pre(Clause clause, StringBuilder output) {
                boolean isSatisfied = Headers.this.checkBundle(clause.getName(), clause.getAttribute("version"));
                Ansi.ansi((StringBuilder)output).fg(isSatisfied ? Ansi.Color.DEFAULT : Ansi.Color.RED).a("");
            }

            public void post(Clause clause, StringBuilder output) {
                Ansi.ansi((StringBuilder)output).reset().a("");
            }
        });
        formatters.put(IMPORT_PACKAGES_ATTRIB, new ClauseFormatter(){

            public void pre(Clause clause, StringBuilder output) {
                boolean isSatisfied = Headers.this.checkPackage(clause.getName(), clause.getAttribute("version"));
                boolean isOptional = "optional".equals(clause.getDirective("resolution"));
                Ansi.ansi((StringBuilder)output).fg(isSatisfied ? Ansi.Color.DEFAULT : Ansi.Color.RED).a(isSatisfied || isOptional ? Ansi.Attribute.INTENSITY_BOLD_OFF : Ansi.Attribute.INTENSITY_BOLD).a("");
            }

            public void post(Clause clause, StringBuilder output) {
                Ansi.ansi((StringBuilder)output).reset().a("");
            }
        });
        for (Map.Entry e : packagesAttribs.entrySet()) {
            output.append((String)e.getKey());
            output.append(" = \n");
            this.formatHeader(Util.getValueString(e.getValue()), (ClauseFormatter)formatters.get(e.getKey()), output, this.indent);
            output.append("\n");
        }
        if (packagesAttribs.size() > 0) {
            output.append('\n');
        }
        return output.toString();
    }

    protected void formatHeader(String header, ClauseFormatter formatter, StringBuilder builder, int indent) {
        Clause[] clauses = Parser.parseHeader(header);
        this.formatClauses(clauses, formatter, builder, indent);
    }

    protected void formatClauses(Clause[] clauses, ClauseFormatter formatter, StringBuilder builder, int indent) {
        boolean first = true;
        for (Clause clause : clauses) {
            if (first) {
                first = false;
            } else {
                builder.append(",\n");
            }
            this.formatClause(clause, formatter, builder, indent);
        }
    }

    protected void formatClause(Clause clause, ClauseFormatter formatter, StringBuilder builder, int indent) {
        builder.append("\t");
        if (formatter != null) {
            formatter.pre(clause, builder);
        }
        this.formatClause(clause, builder, indent);
        if (formatter != null) {
            formatter.post(clause, builder);
        }
    }

    protected int getTermWidth() {
        Terminal term = (Terminal)this.session.get(".jline.terminal");
        return term != null ? term.getWidth() : 80;
    }

    protected void formatClause(Clause clause, StringBuilder builder, int indent) {
        String v;
        int i;
        if (indent < 0) {
            indent = clause.toString().length() < this.getTermWidth() - 8 ? 1 : 3;
        }
        String name = clause.getName();
        Directive[] directives = clause.getDirectives();
        Attribute[] attributes = clause.getAttributes();
        Arrays.sort(directives, new Comparator<Directive>(){

            @Override
            public int compare(Directive o1, Directive o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Arrays.sort(attributes, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute o1, Attribute o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        builder.append(name);
        for (i = 0; directives != null && i < directives.length; ++i) {
            builder.append(";");
            if (indent > 1) {
                builder.append("\n\t\t");
            }
            builder.append(directives[i].getName()).append(":=");
            v = directives[i].getValue();
            if (v.contains(",")) {
                if (indent > 2 && v.length() > 20) {
                    v = v.replace(",", ",\n\t\t\t");
                }
                builder.append("\"").append(v).append("\"");
                continue;
            }
            builder.append(v);
        }
        for (i = 0; attributes != null && i < attributes.length; ++i) {
            builder.append(";");
            if (indent > 1) {
                builder.append("\n\t\t");
            }
            builder.append(attributes[i].getName()).append("=");
            v = attributes[i].getValue();
            if (v.contains(",")) {
                if (indent > 2 && v.length() > 20) {
                    v = v.replace(",", ",\n\t\t\t");
                }
                builder.append("\"").append(v).append("\"");
                continue;
            }
            builder.append(v);
        }
    }

    private boolean checkBundle(String bundleName, String version) {
        if (this.admin != null) {
            Bundle[] bundles = this.admin.getBundles(bundleName, version);
            return bundles != null && bundles.length > 0;
        }
        return false;
    }

    private boolean checkPackage(String packageName, String version) {
        ExportedPackage[] packages;
        VersionRange range = VersionRange.parseVersionRange(version);
        if (this.admin != null && (packages = this.admin.getExportedPackages(packageName)) != null) {
            for (ExportedPackage export : packages) {
                if (!range.contains(export.getVersion())) continue;
                return true;
            }
        }
        return false;
    }

    protected static interface ClauseFormatter {
        public void pre(Clause var1, StringBuilder var2);

        public void post(Clause var1, StringBuilder var2);
    }
}

