/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="osgi", name="name", description="Show or change Karaf instance name.")
public class Name
extends OsgiCommandSupport {
    @Argument(name="name", index=0, description="New name of the Karaf instance.", required=false, multiValued=false)
    String name;

    protected Object doExecute() throws Exception {
        if (this.name == null) {
            System.out.println(this.bundleContext.getProperty("karaf.name"));
        } else {
            try {
                String karafBase = this.bundleContext.getProperty("karaf.base");
                File etcDir = new File(karafBase, "etc");
                File syspropsFile = new File(etcDir, "system.properties");
                FileInputStream fis = new FileInputStream(syspropsFile);
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                props.setProperty("karaf.name", this.name);
                FileOutputStream fos = new FileOutputStream(syspropsFile);
                props.store(fos, "");
                fos.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            System.out.println("Instance name changed to " + this.name + ". Restart needed for this to take effect.");
        }
        return null;
    }
}

