/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.exec;

import java.io.IOException;
import java.io.InputStream;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.util.DOMUtil;
import org.apache.servicemix.exec.marshaler.DefaultExecMarshaler;
import org.apache.servicemix.exec.marshaler.ExecMarshalerSupport;
import org.apache.servicemix.exec.marshaler.ExecRequest;
import org.apache.servicemix.exec.marshaler.ExecResponse;
import org.apache.servicemix.exec.utils.ExecUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ExecEndpoint
extends ProviderEndpoint {
    public static final String DEFAULT_WSDL = "servicemix-exec.wsdl";
    private String command;
    private Resource wsdl;
    private ExecMarshalerSupport marshaler = new DefaultExecMarshaler();

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public ExecMarshalerSupport getMarshaler() {
        return this.marshaler;
    }

    public Resource getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public void setMarshaler(ExecMarshalerSupport marshaler) {
        this.marshaler = marshaler;
    }

    public void validate() throws DeploymentException {
        try {
            int i;
            if (this.wsdl == null) {
                this.wsdl = new ClassPathResource(DEFAULT_WSDL);
            }
            this.description = this.parse(this.wsdl.getInputStream());
            this.definition = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, this.description);
            QName[] qnames = this.definition.getServices().keySet().toArray(new QName[0]);
            for (i = 0; i < qnames.length; ++i) {
                this.definition.removeService(qnames[i]);
            }
            qnames = this.definition.getBindings().keySet().toArray(new QName[0]);
            for (i = 0; i < qnames.length; ++i) {
                this.definition.removeBinding(qnames[i]);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Can't load the WSDL.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document parse(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = DOMUtil.getBuilder();
        try {
            Document document = builder.parse(is);
            return document;
        }
        finally {
            DOMUtil.releaseBuilder((DocumentBuilder)builder);
        }
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        this.handleProviderExchange(exchange);
    }

    protected void handleProviderExchange(MessageExchange exchange) throws Exception {
        if (exchange.getFault() != null) {
            this.done(exchange);
            return;
        }
        ExecRequest execRequest = null;
        if (exchange.getMessage("in") != null) {
            logger.debug("Received exchange: {}", (Object)exchange);
            NormalizedMessage in = exchange.getMessage("in");
            execRequest = this.marshaler.unmarshal(in);
        }
        if (execRequest == null || execRequest.getCommand() == null || execRequest.getCommand().trim().length() < 1) {
            execRequest.setCommand(this.command);
        }
        if (execRequest == null || execRequest.getCommand() == null || execRequest.getCommand().trim().length() < 1) {
            throw new MessagingException("No command to execute.");
        }
        ExecResponse execResponse = ExecUtils.execute(execRequest);
        if (exchange instanceof InOut) {
            NormalizedMessage out = exchange.createMessage();
            this.marshaler.marshal(execResponse, out);
            exchange.setMessage(out, "out");
            this.send(exchange);
        } else {
            this.done(exchange);
        }
    }
}

