/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.util.EventObject;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.impl.ExecutorFactoryImpl;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.EndpointRegistry;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.WireRegistry;
import org.apache.servicemix.nmr.api.event.ListenerRegistry;
import org.apache.servicemix.nmr.api.internal.FlowRegistry;
import org.apache.servicemix.nmr.api.service.ServiceHelper;
import org.apache.servicemix.nmr.core.ClientChannel;
import org.apache.servicemix.nmr.core.EndpointRegistryImpl;
import org.apache.servicemix.nmr.core.FlowRegistryImpl;
import org.apache.servicemix.nmr.core.ListenerRegistryImpl;
import org.apache.servicemix.nmr.core.NmrStartedEvent;
import org.apache.servicemix.nmr.core.NmrStoppedEvent;
import org.apache.servicemix.nmr.core.StraightThroughFlow;
import org.apache.servicemix.nmr.core.WireRegistryImpl;
import org.fusesource.commons.management.ManagementStrategy;

public class ServiceMix
implements NMR {
    public static final String EXECUTOR_CLIENT = "nmr.client";
    private EndpointRegistry endpoints;
    private ListenerRegistry listeners;
    private FlowRegistry flows;
    private WireRegistry wires;
    private ExecutorFactory executorFactory;
    private ManagementStrategy managementStrategy;
    private String id;

    public void init() {
        Object reg;
        if (this.executorFactory == null) {
            this.createExecutorFactory();
        }
        if (this.endpoints == null) {
            reg = new EndpointRegistryImpl(this);
            ((EndpointRegistryImpl)reg).setExecutorFactory(this.executorFactory);
            ((EndpointRegistryImpl)reg).init();
            this.endpoints = reg;
        }
        if (this.listeners == null) {
            this.listeners = new ListenerRegistryImpl();
        }
        if (this.flows == null) {
            reg = new FlowRegistryImpl();
            ((FlowRegistryImpl)reg).setRegistry(this.endpoints);
            this.flows = reg;
            this.flows.register((Object)new StraightThroughFlow(), ServiceHelper.createMap((String[])new String[]{"ID", StraightThroughFlow.class.getName()}));
        }
        if (this.wires == null) {
            this.wires = new WireRegistryImpl();
        }
        this.fireEvent(new NmrStartedEvent(this));
    }

    public void shutdown() {
        this.fireEvent(new NmrStoppedEvent(this));
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpoints;
    }

    public void setEndpointRegistry(EndpointRegistry endpoints) {
        this.endpoints = endpoints;
    }

    public ListenerRegistry getListenerRegistry() {
        return this.listeners;
    }

    public void setListenerRegistry(ListenerRegistry listeners) {
        this.listeners = listeners;
    }

    public FlowRegistry getFlowRegistry() {
        return this.flows;
    }

    public void setFlowRegistry(FlowRegistry flows) {
        this.flows = flows;
    }

    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public Channel createChannel() {
        return new ClientChannel(this, this.executorFactory.createExecutor(EXECUTOR_CLIENT));
    }

    public WireRegistry getWireRegistry() {
        return this.wires;
    }

    public void setWireRegistry(WireRegistry wires) {
        this.wires = wires;
    }

    public ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    public void bindManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    public void unbindManagementStrategy(ManagementStrategy ms) {
        this.managementStrategy = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private void createExecutorFactory() {
        ExecutorFactoryImpl impl = new ExecutorFactoryImpl();
        impl.getDefaultConfig().setBypassIfSynchronous(Boolean.valueOf(true));
        this.executorFactory = impl;
    }

    private void fireEvent(EventObject event) {
        try {
            ManagementStrategy ms = this.getManagementStrategy();
            if (ms != null) {
                ms.notify(event);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

