/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.rules;

import java.util.HashSet;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RuleHandler
extends BaseAbstractHandler
implements Handler {
    public RuleHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(PackageDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(FunctionDescr.class);
            this.validPeers.add(RuleDescr.class);
            this.validPeers.add(QueryDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String ruleName = attrs.getValue("name");
        this.emptyAttributeCheck(localName, "name", ruleName, parser);
        RuleDescr ruleDescr = new RuleDescr(ruleName.trim());
        return ruleDescr;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        RuleDescr ruleDescr = (RuleDescr)parser.getCurrent();
        AndDescr lhs = ruleDescr.getLhs();
        if (lhs == null) {
            throw new SAXParseException("<rule> requires a LHS", parser.getLocator());
        }
        NodeList list = element.getElementsByTagName("rhs");
        if (list.getLength() == 0) {
            throw new SAXParseException("<rule> requires a <rh> child element", parser.getLocator());
        }
        ruleDescr.setConsequence(((Text)list.item(0).getChildNodes().item(0)).getWholeText());
        NodeList attributes = element.getElementsByTagName("rule-attribute");
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String name = ((Element)attributes.item(i)).getAttribute("name");
            this.emptyAttributeCheck("rule-attribute", "name", name, parser);
            String value = ((Element)attributes.item(i)).getAttribute("value");
            ruleDescr.addAttribute(new AttributeDescr(name, value));
        }
        ((PackageDescr)parser.getData()).addRule(ruleDescr);
        return ruleDescr;
    }

    public Class generateNodeFor() {
        return RuleDescr.class;
    }
}

