/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.Map;
import org.drools.base.dataproviders.MVELDataProvider;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.AccessorDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.rule.Declaration;
import org.drools.rule.From;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELDialect;

public class MVELFromBuilder
implements FromBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        FromDescr fromDescr = (FromDescr)descr;
        AccessorDescr accessor = (AccessorDescr)fromDescr.getDataSource();
        From from = null;
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            String text = accessor.toString();
            Dialect.AnalysisResult analysis = dialect.analyzeExpression(context, descr, text, new Map[]{context.getDeclarationResolver().getDeclarationClasses(context.getRule()), context.getPackageBuilder().getGlobals()});
            Declaration[] previousDeclarations = context.getDeclarationResolver().getDeclarations(context.getRule()).values().toArray(new Declaration[context.getDeclarationResolver().getDeclarations(context.getRule()).size()]);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, previousDeclarations, null, null, context);
            MVELDataProvider dataProvider = new MVELDataProvider(unit, context.getDialect().getId());
            from = new From(dataProvider);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(dialect.getId());
            data.addCompileable(from, dataProvider);
            dataProvider.compile(context.getPackageBuilder().getRootClassLoader());
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), fromDescr, null, "Unable to build expression for 'from' : " + e.getMessage() + " '" + accessor + "'"));
            return null;
        }
        return from;
    }
}

