/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.document.impl.spring;

import org.apache.servicemix.document.DocumentRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.osgi.context.BundleContextAware;

public class SpringDocumentFactory
implements FactoryBean,
BundleContextAware,
InitializingBean,
BeanFactoryPostProcessor,
BeanNameAware,
BeanFactoryAware {
    private BundleContext bundleContext;
    private String document;
    private String documentId;
    private BeanFactory beanFactory;
    private String beanName;
    private DocumentRepository repository;

    public Object getObject() throws Exception {
        return this.documentId;
    }

    public Class getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setRepository(DocumentRepository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.document == null) {
            throw new IllegalStateException("document must be set");
        }
        if (this.repository != null) {
            this.documentId = this.repository.register(this.document.getBytes());
        } else if (this.bundleContext != null) {
            ServiceReference ref = this.bundleContext.getServiceReference(DocumentRepository.class.getName());
            if (ref == null) {
                throw new IllegalStateException("Can not get a reference to the DocumentRepository");
            }
            try {
                DocumentRepository rep = (DocumentRepository)this.bundleContext.getService(ref);
                this.documentId = rep.register(this.document.getBytes());
            }
            finally {
                if (ref != null) {
                    this.bundleContext.ungetService(ref);
                }
            }
        } else {
            throw new IllegalStateException("repoitory or bundleContext must be set");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactoryToProcess) throws BeansException {
        BundleExtUrlBeanDefinitionVisitor visitor = new BundleExtUrlBeanDefinitionVisitor();
        String[] beanNames = beanFactoryToProcess.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            if (beanNames[i].equals(this.beanName) && beanFactoryToProcess.equals(this.beanFactory)) continue;
            BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(beanNames[i]);
            try {
                visitor.visitBeanDefinition(bd);
                continue;
            }
            catch (BeanDefinitionStoreException ex) {
                throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], ex.getMessage());
            }
        }
    }

    private class BundleExtUrlBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        private BundleExtUrlBeanDefinitionVisitor() {
        }

        protected String resolveStringValue(String string) {
            if (string.equals("document-name:" + SpringDocumentFactory.this.beanName)) {
                string = SpringDocumentFactory.this.documentId;
            }
            return string;
        }
    }
}

