/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileBinding;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class FileConsumer
extends GenericFileConsumer<File> {
    private String endpointPath;

    public FileConsumer(GenericFileEndpoint<File> endpoint, Processor processor, GenericFileOperations<File> operations) {
        super(endpoint, processor, operations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    @Override
    protected boolean pollDirectory(String fileName, List<GenericFile<File>> fileList, int depth) {
        this.log.trace("pollDirectory from fileName: {}", (Object)fileName);
        ++depth;
        File directory = new File(fileName);
        if (!directory.exists() || !directory.isDirectory()) {
            this.log.debug("Cannot poll as directory does not exists or its not a directory: {}", (Object)directory);
            if (this.getEndpoint().isDirectoryMustExist()) {
                throw new GenericFileOperationFailedException("Directory does not exist: " + directory);
            }
            return true;
        }
        this.log.trace("Polling directory: {}", (Object)directory.getPath());
        File[] dirFiles = directory.listFiles();
        if (dirFiles == null || dirFiles.length == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("No files found in directory: {}", (Object)directory.getPath());
            }
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Found {} in directory: {}", (Object)dirFiles.length, (Object)directory.getPath());
        }
        List<File> files = Arrays.asList(dirFiles);
        for (File file : files) {
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Found file: {} [isAbsolute: {}, isDirectory: {}, isFile: {}, isHidden: {}]", new Object[]{file, file.isAbsolute(), file.isDirectory(), file.isFile(), file.isHidden()});
            }
            GenericFile<File> gf = FileConsumer.asGenericFile(this.endpointPath, file, this.getEndpoint().getCharset());
            if (file.isDirectory()) {
                String subDirectory;
                boolean canPollMore;
                if (!this.endpoint.isRecursive() || !this.isValidFile(gf, true, files) || depth >= this.endpoint.getMaxDepth() || (canPollMore = this.pollDirectory(subDirectory = fileName + File.separator + file.getName(), fileList, depth))) continue;
                return false;
            }
            if (!this.isValidFile(gf, false, files) || depth < this.endpoint.minDepth) continue;
            if (this.isInProgress(gf)) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("Skipping as file is already in progress: {}", (Object)gf.getFileName());
                continue;
            }
            this.log.trace("Adding valid file: {}", (Object)file);
            fileList.add(gf);
        }
        return true;
    }

    @Override
    protected boolean isMatched(GenericFile<File> file, String doneFileName, List<File> files) {
        String onlyName = FileUtil.stripPath(doneFileName);
        for (File f : files) {
            if (!f.getName().equals(onlyName)) continue;
            return true;
        }
        this.log.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    public static GenericFile<File> asGenericFile(String endpointPath, File file, String charset) {
        GenericFile<File> answer = new GenericFile<File>();
        answer.setBinding(new FileBinding());
        answer.setCharset(charset);
        answer.setEndpointPath(endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getName());
        answer.setFileLength(file.length());
        answer.setDirectory(file.isDirectory());
        answer.setAbsolute(FileUtil.isAbsolute(file));
        answer.setAbsoluteFilePath(file.getAbsolutePath());
        answer.setLastModified(file.lastModified());
        String endpointNormalized = FileUtil.normalizePath(endpointPath);
        File path = file.getPath().startsWith(endpointNormalized + File.separator) ? new File(ObjectHelper.after(file.getPath(), endpointNormalized + File.separator)) : new File(file.getPath());
        if (path.getParent() != null) {
            answer.setRelativeFilePath(path.getParent() + File.separator + file.getName());
        } else {
            answer.setRelativeFilePath(path.getName());
        }
        answer.setFileName(answer.getRelativeFilePath());
        answer.setBody(file);
        return answer;
    }

    @Override
    public FileEndpoint getEndpoint() {
        return (FileEndpoint)super.getEndpoint();
    }
}

