/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.main.util.InterpolationHelper;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends AbstractMap<String, String> {
    private static final String COMMENT_CHARS = "#!";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private final Map<String, String> storage = new LinkedHashMap<String, String>();
    private final Map<String, Layout> layout = new LinkedHashMap<String, Layout>();
    private List<String> header;
    private List<String> footer;
    private File location;
    private BundleContext context;

    public Properties() {
    }

    public Properties(File location) throws IOException {
        this(location, null);
    }

    public Properties(File location, BundleContext context) throws IOException {
        this.location = location;
        this.context = context;
        if (location.exists()) {
            this.load(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File location) throws IOException {
        FileInputStream is = new FileInputStream(location);
        try {
            this.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL location) throws IOException {
        InputStream is = location.openStream();
        try {
            this.load(is);
        }
        finally {
            is.close();
        }
    }

    public void load(InputStream is) throws IOException {
        this.load(new InputStreamReader(is, DEFAULT_ENCODING));
    }

    public void load(Reader reader) throws IOException {
        this.loadLayout(reader);
    }

    public void save() throws IOException {
        this.save(this.location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File location) throws IOException {
        FileOutputStream os = new FileOutputStream(location);
        try {
            this.save(os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public void save(OutputStream os) throws IOException {
        this.save(new OutputStreamWriter(os, DEFAULT_ENCODING));
    }

    public void save(Writer writer) throws IOException {
        this.saveLayout(writer);
    }

    public void store(OutputStream os, String comment) throws IOException {
        this.save(os);
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.get(key) != null) {
            return (String)this.get(key);
        }
        return defaultValue;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.storage.entrySet();
    }

    public Enumeration<?> propertyNames() {
        return Collections.enumeration(this.storage.keySet());
    }

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public String put(String key, String value) {
        Layout l;
        String old = this.storage.put(key, value);
        if (!(old != null && old.equals(value) || (l = this.layout.get(key)) == null)) {
            l.clearValue();
        }
        return old;
    }

    public String put(String key, List<String> commentLines, List<String> valueLines) {
        commentLines = new ArrayList<String>(commentLines);
        valueLines = new ArrayList<String>(valueLines);
        String escapedKey = Properties.escapeKey(key);
        int lastLine = valueLines.size() - 1;
        if (valueLines.isEmpty()) {
            valueLines.add(escapedKey + "=");
        } else if (!valueLines.get(0).trim().startsWith(escapedKey)) {
            valueLines.set(0, escapedKey + " = " + Properties.escapeJava(valueLines.get(0)) + (0 < lastLine ? "\\" : ""));
        }
        for (int i = 1; i < valueLines.size(); ++i) {
            valueLines.set(i, Properties.escapeJava(valueLines.get(i)) + (i < lastLine ? "\\" : ""));
        }
        StringBuilder value = new StringBuilder();
        for (String line : valueLines) {
            value.append(line);
        }
        this.layout.put(key, new Layout(commentLines, valueLines));
        return this.storage.put(key, Properties.unescapeJava(value.toString()));
    }

    public String put(String key, List<String> commentLines, String value) {
        commentLines = new ArrayList<String>(commentLines);
        this.layout.put(key, new Layout(commentLines, null));
        return this.storage.put(key, value);
    }

    public String put(String key, String comment, String value) {
        return this.put(key, Collections.singletonList(comment), value);
    }

    public List<String> getRaw(String key) {
        if (this.layout.containsKey(key) && this.layout.get(key).getValueLines() != null) {
            return new ArrayList<String>(this.layout.get(key).getValueLines());
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.storage.containsKey(key)) {
            result.add(this.storage.get(key));
        }
        return result;
    }

    @Override
    public String remove(Object key) {
        Layout l = this.layout.get(key);
        if (l != null) {
            l.clearValue();
        }
        return this.storage.remove(key);
    }

    @Override
    public void clear() {
        for (Layout l : this.layout.values()) {
            l.clearValue();
        }
        this.storage.clear();
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public List<String> getFooter() {
        return this.footer;
    }

    public void setFooter(List<String> footer) {
        this.footer = footer;
    }

    protected void loadLayout(Reader in) throws IOException {
        PropertiesReader reader = new PropertiesReader(in);
        while (reader.nextProperty()) {
            this.storage.put(reader.getPropertyName(), reader.getPropertyValue());
            int idx = this.checkHeaderComment(reader.getCommentLines());
            this.layout.put(reader.getPropertyName(), new Layout((List<String>)(idx < reader.getCommentLines().size() ? new ArrayList<String>(reader.getCommentLines().subList(idx, reader.getCommentLines().size())) : null), new ArrayList<String>(reader.getValueLines())));
        }
        this.footer = new ArrayList<String>(reader.getCommentLines());
        if (this.context != null) {
            InterpolationHelper.performSubstitution(this.storage, this.context);
        } else {
            InterpolationHelper.performSubstitution(this.storage);
        }
    }

    protected void saveLayout(Writer out) throws IOException {
        PropertiesWriter writer = new PropertiesWriter(out);
        if (this.header != null) {
            for (String s : this.header) {
                writer.writeln(s);
            }
        }
        for (String key : this.storage.keySet()) {
            Layout l = this.layout.get(key);
            if (l != null && l.getCommentLines() != null) {
                for (String s : l.getCommentLines()) {
                    writer.writeln(s);
                }
            }
            if (l != null && l.getValueLines() != null) {
                for (String s : l.getValueLines()) {
                    writer.writeln(s);
                }
                continue;
            }
            writer.writeProperty(key, this.storage.get(key));
        }
        if (this.footer != null) {
            for (String s : this.footer) {
                writer.writeln(s);
            }
        }
        writer.flush();
    }

    private int checkHeaderComment(List<String> commentLines) {
        if (this.getHeader() == null && this.layout.isEmpty()) {
            int index;
            for (index = commentLines.size() - 1; index >= 0 && commentLines.get(index).length() > 0; --index) {
            }
            this.setHeader(new ArrayList<String>(commentLines.subList(0, index + 1)));
            return index + 1;
        }
        return 0;
    }

    static boolean isCommentLine(String line) {
        String s = line.trim();
        return s.length() < 1 || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    protected static String unescapeJava(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer out = new StringBuffer(sz);
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\'': {
                        out.append('\'');
                        break;
                    }
                    case '\"': {
                        out.append('\"');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    protected static String escapeJava(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer out = new StringBuffer(sz * 2);
        block11: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.append("\\u").append(Properties.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.append("\\u0").append(Properties.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.append("\\u00").append(Properties.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00").append(Properties.hex(ch));
                            break;
                        }
                        out.append("\\u000").append(Properties.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    continue block11;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block11;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    protected static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static boolean contains(char[] array, char valueToFind) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return true;
        }
        return false;
    }

    private static String escapeKey(String key) {
        StringBuffer newkey = new StringBuffer();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Properties.contains(SEPARATORS, c) || Properties.contains(WHITE_SPACE, c)) {
                newkey.append('\\');
                newkey.append(c);
                continue;
            }
            newkey.append(c);
        }
        return newkey.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Layout {
        private List<String> commentLines;
        private List<String> valueLines;

        public Layout() {
        }

        public Layout(List<String> commentLines, List<String> valueLines) {
            this.commentLines = commentLines;
            this.valueLines = valueLines;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public void setCommentLines(List<String> commentLines) {
            this.commentLines = commentLines;
        }

        public List<String> getValueLines() {
            return this.valueLines;
        }

        public void setValueLines(List<String> valueLines) {
            this.valueLines = valueLines;
        }

        public void clearValue() {
            this.valueLines = null;
        }
    }

    public static class PropertiesWriter
    extends FilterWriter {
        public PropertiesWriter(Writer writer) {
            super(writer);
        }

        public void writeProperty(String key, String value) throws IOException {
            this.write(Properties.escapeKey(key));
            this.write(" = ");
            this.write(Properties.escapeJava(value));
            this.writeln(null);
        }

        public void writeln(String s) throws IOException {
            if (s != null) {
                this.write(s);
            }
            this.write(LINE_SEPARATOR);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesReader
    extends LineNumberReader {
        private final List<String> commentLines = new ArrayList<String>();
        private final List<String> valueLines = new ArrayList<String>();
        private String propertyName;
        private String propertyValue;

        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            String line;
            this.commentLines.clear();
            this.valueLines.clear();
            StringBuffer buffer = new StringBuffer();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (Properties.isCommentLine(line)) {
                    this.commentLines.add(line);
                    continue;
                }
                this.valueLines.add(line);
                line = line.trim();
                if (!PropertiesReader.checkCombineLines(line)) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            String[] property = PropertiesReader.parseProperty(line);
            this.propertyName = Properties.unescapeJava(property[0]);
            this.propertyValue = Properties.unescapeJava(property[1]);
            return true;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public List<String> getValueLines() {
            return this.valueLines;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        private static boolean checkCombineLines(String line) {
            int bsCount = 0;
            for (int idx = line.length() - 1; idx >= 0 && line.charAt(idx) == '\\'; --idx) {
                ++bsCount;
            }
            return bsCount % 2 != 0;
        }

        private static String[] parseProperty(String line) {
            String[] result = new String[2];
            StringBuffer key = new StringBuffer();
            StringBuffer value = new StringBuffer();
            int state = 0;
            block6: for (int pos = 0; pos < line.length(); ++pos) {
                char c = line.charAt(pos);
                switch (state) {
                    case 0: {
                        if (c == '\\') {
                            state = 1;
                            continue block6;
                        }
                        if (Properties.contains(WHITE_SPACE, c)) {
                            state = 2;
                            continue block6;
                        }
                        if (Properties.contains(SEPARATORS, c)) {
                            state = 3;
                            continue block6;
                        }
                        key.append(c);
                        continue block6;
                    }
                    case 1: {
                        if (Properties.contains(SEPARATORS, c) || Properties.contains(WHITE_SPACE, c)) {
                            key.append(c);
                        } else {
                            key.append('\\');
                            key.append(c);
                        }
                        state = 0;
                        continue block6;
                    }
                    case 2: {
                        if (Properties.contains(WHITE_SPACE, c)) {
                            state = 2;
                            continue block6;
                        }
                        if (Properties.contains(SEPARATORS, c)) {
                            state = 3;
                            continue block6;
                        }
                        value.append(c);
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        value.append(c);
                    }
                }
            }
            result[0] = key.toString().trim();
            result[1] = value.toString().trim();
            return result;
        }
    }
}

