/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.maven.commons;

import java.io.File;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.maven.commons.MavenConfiguration;
import org.ops4j.pax.url.maven.commons.MavenRepositoryURL;
import org.ops4j.pax.url.maven.commons.MavenSettings;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenConfigurationImpl
extends PropertyStore
implements MavenConfiguration {
    private static final Log LOGGER = LogFactory.getLog(MavenConfigurationImpl.class);
    private static final String REPOSITORIES_APPEND_SIGN = "+";
    private static final String REPOSITORIES_SEPARATOR = ",";
    private MavenSettings m_settings;
    private final String m_pid;
    private final PropertyResolver m_propertyResolver;

    public MavenConfigurationImpl(PropertyResolver propertyResolver, String pid) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        NullArgumentException.validateNotEmpty(pid, true, "Configuration pid");
        this.m_pid = pid;
        this.m_propertyResolver = propertyResolver;
    }

    public void setSettings(MavenSettings settings) {
        this.m_settings = settings;
    }

    @Override
    public Boolean getCertificateCheck() {
        if (!this.contains(this.m_pid + ".certificateCheck")) {
            return this.set(this.m_pid + ".certificateCheck", Boolean.valueOf(this.m_propertyResolver.get(this.m_pid + ".certificateCheck")));
        }
        return (Boolean)this.get(this.m_pid + ".certificateCheck");
    }

    @Override
    public URL getSettingsFileUrl() {
        block6: {
            String spec;
            if (!this.contains(this.m_pid + ".settings") && (spec = this.m_propertyResolver.get(this.m_pid + ".settings")) != null) {
                try {
                    return this.set(this.m_pid + ".settings", new URL(spec));
                }
                catch (MalformedURLException e) {
                    File file = new File(spec);
                    if (file.exists()) {
                        try {
                            return this.set(this.m_pid + ".settings", file.toURL());
                        }
                        catch (MalformedURLException ignore) {
                            break block6;
                        }
                    }
                    LOGGER.warn("Settings file [" + spec + "] cannot be used and will be skipped (malformed url or file does not exist)");
                    this.set(this.m_pid + ".settings", null);
                }
            }
        }
        return (URL)this.get(this.m_pid + ".settings");
    }

    @Override
    public List<MavenRepositoryURL> getDefaultRepositories() throws MalformedURLException {
        if (!this.contains(this.m_pid + ".defaultRepositories")) {
            String defaultRepositoriesProp = this.m_propertyResolver.get(this.m_pid + ".defaultRepositories");
            ArrayList<MavenRepositoryURL> defaultRepositoriesProperty = new ArrayList<MavenRepositoryURL>();
            MavenRepositoryURL localRepository = this.getLocalRepository();
            if (defaultRepositoriesProp != null && defaultRepositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = defaultRepositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    defaultRepositoriesProperty.add(new MavenRepositoryURL(repositoryURL));
                }
            }
            LOGGER.trace("Using repositories [" + defaultRepositoriesProperty + "]");
            return this.set(this.m_pid + ".defaultRepositories", defaultRepositoriesProperty);
        }
        return (List)this.get(this.m_pid + ".defaultRepositories");
    }

    @Override
    public List<MavenRepositoryURL> getRepositories() throws MalformedURLException {
        if (!this.contains(this.m_pid + ".repositories")) {
            String settingsRepos;
            String repositoriesProp = this.m_propertyResolver.get(this.m_pid + ".repositories");
            if ((repositoriesProp == null || repositoriesProp.startsWith(REPOSITORIES_APPEND_SIGN)) && this.m_settings != null && (settingsRepos = this.m_settings.getRepositories()) != null) {
                repositoriesProp = repositoriesProp == null ? settingsRepos : repositoriesProp.substring(1) + REPOSITORIES_SEPARATOR + settingsRepos;
            }
            ArrayList<MavenRepositoryURL> repositoriesProperty = new ArrayList<MavenRepositoryURL>();
            MavenRepositoryURL localRepository = this.getLocalRepository();
            if (localRepository != null) {
                repositoriesProperty.add(localRepository);
            }
            if (repositoriesProp != null && repositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = repositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    repositoriesProperty.add(new MavenRepositoryURL(repositoryURL));
                }
            }
            LOGGER.trace("Using repositories [" + repositoriesProperty + "]");
            return this.set(this.m_pid + ".repositories", repositoriesProperty);
        }
        return (List)this.get(this.m_pid + ".repositories");
    }

    @Override
    public MavenRepositoryURL getLocalRepository() {
        if (!this.contains(this.m_pid + ".localRepository")) {
            String spec = this.m_propertyResolver.get(this.m_pid + ".localRepository");
            if (spec == null && this.m_settings != null) {
                spec = this.m_settings.getLocalRepository();
            }
            if (spec != null) {
                if (!spec.toLowerCase().contains("@snapshots")) {
                    spec = spec + "@snapshots";
                }
                spec = spec + "@id=local";
                try {
                    return this.set(this.m_pid + ".localRepository", new MavenRepositoryURL(spec));
                }
                catch (MalformedURLException e) {
                    try {
                        return this.set(this.m_pid + ".localRepository", new MavenRepositoryURL(new File(spec).toURI().toASCIIString()));
                    }
                    catch (MalformedURLException ignore) {
                        LOGGER.warn("Local repository [" + spec + "] cannot be used and will be skipped");
                        return this.set(this.m_pid + ".localRepository", null);
                    }
                }
            }
        }
        return (MavenRepositoryURL)this.get(this.m_pid + ".localRepository");
    }

    @Override
    public Boolean useFallbackRepositories() {
        if (!this.contains(this.m_pid + ".useFallbackRepositories")) {
            String useFallbackRepoProp = this.m_propertyResolver.get(this.m_pid + ".useFallbackRepositories");
            return this.set(this.m_pid + ".useFallbackRepositories", Boolean.valueOf(useFallbackRepoProp == null ? "true" : useFallbackRepoProp));
        }
        return (Boolean)this.get(this.m_pid + ".useFallbackRepositories");
    }

    @Override
    public void enableProxy(URL url) {
        String protocol = url.getProtocol();
        Map<String, String> proxyDetails = this.getProxySettings(url.getProtocol()).get(protocol);
        if (proxyDetails != null) {
            LOGGER.trace("Enabling proxy [" + proxyDetails + "]");
            final String user = proxyDetails.get("user");
            final String pass = proxyDetails.get("pass");
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            });
            System.setProperty(protocol + ".proxyHost", proxyDetails.get("host"));
            System.setProperty(protocol + ".proxyPort", proxyDetails.get("port"));
            System.setProperty(protocol + ".nonProxyHosts", proxyDetails.get("nonProxyHosts"));
            this.set(this.m_pid + ".proxySupport", protocol);
        }
    }

    private boolean isProtocolSupportEnabled(String ... protocols) {
        String proxySupport = this.m_propertyResolver.get(this.m_pid + ".proxySupport");
        if (proxySupport == null) {
            return true;
        }
        if ("true".equalsIgnoreCase(proxySupport)) {
            return true;
        }
        if ("false".equalsIgnoreCase(proxySupport)) {
            return false;
        }
        if (protocols.length == 0) {
            return true;
        }
        for (String protocol : protocols) {
            if (!proxySupport.contains(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Map<String, String>> getProxySettings(String ... protocols) {
        HashMap<String, Map<String, String>> pr = new HashMap<String, Map<String, String>>();
        if (this.isProtocolSupportEnabled(protocols)) {
            this.parseSystemWideProxySettings(pr);
            this.parseProxiesFromProperty(this.m_propertyResolver.get(this.m_pid + ".proxies"), pr);
            if (pr.isEmpty()) {
                if (this.m_settings == null) {
                    return Collections.emptyMap();
                }
                return this.m_settings.getProxySettings();
            }
        }
        return pr;
    }

    private void parseSystemWideProxySettings(Map<String, Map<String, String>> pr) {
        String httpHost = this.m_propertyResolver.get("http.proxyHost");
        String httpPort = this.m_propertyResolver.get("http.proxyPort");
        if (httpHost != null) {
            this.parseProxiesFromProperty("http:host=" + httpHost + ",port=" + httpPort, pr);
        }
    }

    private void parseProxiesFromProperty(String proxySettings, Map<String, Map<String, String>> pr) {
        try {
            if (proxySettings != null) {
                String[] protocols;
                for (String protocolSection : protocols = proxySettings.split(";")) {
                    String[] section = protocolSection.split(":");
                    String protocolName = section[0];
                    HashMap<String, String> keyvalue = new HashMap<String, String>();
                    keyvalue.put("protocol", protocolName);
                    keyvalue.put("nonProxyHosts", "");
                    keyvalue.put("host", "localhost");
                    keyvalue.put("port", "80");
                    keyvalue.put("nonProxyHosts", "");
                    for (String keyvalueList : section[1].split(REPOSITORIES_SEPARATOR)) {
                        String[] kv = keyvalueList.split("=");
                        String key = kv[0];
                        String value = kv[1];
                        keyvalue.put(key, value);
                    }
                    pr.put(protocolName, keyvalue);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Proxy setting is set to " + proxySettings + ". But it should have this format: <protocol>:<key>=<value>,<key=value>;protocol:<key>=<value>,..");
        }
    }

    @Override
    public Map<String, Map<String, String>> getMirrors() {
        if (this.m_settings == null) {
            return Collections.emptyMap();
        }
        return this.m_settings.getMirrorSettings();
    }
}

