/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap.interceptors;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.bindings.soap.SoapConstants;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.util.stax.StaxUtil;
import org.w3c.dom.Element;

public class SoapFaultInInterceptor
extends AbstractInterceptor {
    public void handleMessage(Message message) {
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        if (xmlReader == null || xmlReader.getEventType() != 1) {
            return;
        }
        SoapVersion soapVersion = message.get(SoapVersion.class);
        if (!soapVersion.getFault().equals(xmlReader.getName())) {
            return;
        }
        Element el = StaxUtil.createElement(xmlReader);
        SoapFault fault = this.readFault(el);
        message.setContent(Exception.class, fault);
    }

    private SoapFault readFault(Element element) throws SoapFault {
        QName code = null;
        QName subcode = null;
        String reason = null;
        URI node = null;
        URI role = null;
        DOMSource details = null;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespaceURI())) {
            Element child = DomUtil.getFirstChildElement(element);
            this.checkElementName(child, SoapConstants.SOAP_11_FAULTCODE);
            code = DomUtil.createQName(child, DomUtil.getElementText(child));
            child = DomUtil.getNextSiblingElement(child);
            this.checkElementName(child, SoapConstants.SOAP_11_FAULTSTRING);
            reason = DomUtil.getElementText(child);
            child = DomUtil.getNextSiblingElement(child);
            QName childname = DomUtil.getQName(child);
            if (SoapConstants.SOAP_11_FAULTACTOR.equals(childname)) {
                node = URI.create(DomUtil.getElementText(child));
                child = DomUtil.getNextSiblingElement(child);
                childname = DomUtil.getQName(child);
            }
            if (SoapConstants.SOAP_11_FAULTDETAIL.equals(childname)) {
                Element subchild = DomUtil.getFirstChildElement(child);
                if (subchild != null) {
                    details = new DOMSource(subchild);
                    if ((subchild = DomUtil.getNextSiblingElement(subchild)) != null) {
                        throw new SoapFault(SoapFault.RECEIVER, "Multiple elements are not supported in Detail");
                    }
                }
                child = DomUtil.getNextSiblingElement(child);
                childname = DomUtil.getQName(child);
            }
            if (childname != null) {
                throw new SoapFault(SoapFault.SENDER, "Unexpected element: " + childname);
            }
        } else {
            Element child = DomUtil.getFirstChildElement(element);
            this.checkElementName(child, SoapConstants.SOAP_12_FAULTCODE);
            Element subchild = DomUtil.getFirstChildElement(child);
            this.checkElementName(subchild, SoapConstants.SOAP_12_FAULTVALUE);
            code = DomUtil.createQName(subchild, DomUtil.getElementText(subchild));
            if (!(SoapConstants.SOAP_12_CODE_DATAENCODINGUNKNOWN.equals(code) || SoapConstants.SOAP_12_CODE_MUSTUNDERSTAND.equals(code) || SoapConstants.SOAP_12_CODE_RECEIVER.equals(code) || SoapConstants.SOAP_12_CODE_SENDER.equals(code) || SoapConstants.SOAP_12_CODE_VERSIONMISMATCH.equals(code))) {
                throw new SoapFault(SoapFault.SENDER, "Unexpected fault code: " + code);
            }
            if ((subchild = DomUtil.getNextSiblingElement(subchild)) != null) {
                this.checkElementName(subchild, SoapConstants.SOAP_12_FAULTSUBCODE);
                Element subsubchild = DomUtil.getFirstChildElement(subchild);
                this.checkElementName(subsubchild, SoapConstants.SOAP_12_FAULTVALUE);
                subcode = DomUtil.createQName(subsubchild, DomUtil.getElementText(subsubchild));
                subsubchild = DomUtil.getNextSiblingElement(subsubchild);
                if (subsubchild != null) {
                    this.checkElementName(subsubchild, SoapConstants.SOAP_12_FAULTSUBCODE);
                    throw new SoapFault(SoapFault.RECEIVER, "Unsupported nested subcodes");
                }
            }
            child = DomUtil.getNextSiblingElement(child);
            this.checkElementName(child, SoapConstants.SOAP_12_FAULTREASON);
            subchild = DomUtil.getFirstChildElement(child);
            this.checkElementName(subchild, SoapConstants.SOAP_12_FAULTTEXT);
            reason = DomUtil.getElementText(subchild);
            subchild = DomUtil.getNextSiblingElement(subchild);
            if (subchild != null) {
                throw new SoapFault(SoapFault.RECEIVER, "Unsupported multiple reasons");
            }
            QName childname = DomUtil.getQName(child = DomUtil.getNextSiblingElement(child));
            if (SoapConstants.SOAP_12_FAULTNODE.equals(childname)) {
                node = URI.create(DomUtil.getElementText(child));
                child = DomUtil.getNextSiblingElement(child);
                childname = DomUtil.getQName(child);
            }
            if (SoapConstants.SOAP_12_FAULTROLE.equals(childname)) {
                role = URI.create(DomUtil.getElementText(child));
                child = DomUtil.getNextSiblingElement(child);
                childname = DomUtil.getQName(child);
            }
            if (SoapConstants.SOAP_12_FAULTDETAIL.equals(childname)) {
                subchild = DomUtil.getFirstChildElement(child);
                if (subchild != null) {
                    details = new DOMSource(subchild);
                    if ((subchild = DomUtil.getNextSiblingElement(subchild)) != null) {
                        throw new SoapFault(SoapFault.RECEIVER, "Multiple elements are not supported in Detail");
                    }
                }
                child = DomUtil.getNextSiblingElement(child);
                childname = DomUtil.getQName(child);
            }
            if (childname != null) {
                throw new SoapFault(SoapFault.SENDER, "Unexpected element: " + childname);
            }
        }
        return new SoapFault(code, subcode, reason, node, role, details);
    }

    private void checkElementName(Element element, QName expected) throws SoapFault {
        QName name = DomUtil.getQName(element);
        if (!expected.equals(name)) {
            throw new SoapFault(SoapFault.SENDER, "Expected element: " + expected + " but found " + name);
        }
    }
}

