/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap.interceptors;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.bindings.soap.SoapConstants;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;
import org.apache.servicemix.soap.bindings.soap.SoapVersionFactory;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.util.stax.StaxUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class SoapInInterceptor
extends AbstractInterceptor {
    private final SoapVersion soapVersion;

    public SoapInInterceptor() {
        this(null);
    }

    public SoapInInterceptor(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public void handleMessage(Message message) {
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        if (xmlReader == null) {
            throw new NullPointerException("No xml reader found");
        }
        try {
            QName name = xmlReader.getName();
            SoapVersion soapVersion = this.soapVersion;
            if (soapVersion == null) {
                soapVersion = message.get(SoapVersion.class);
            }
            if ((soapVersion = soapVersion == null ? SoapVersionFactory.getInstance().getSoapVersion(name) : soapVersion.getDerivedVersion(name.getPrefix())) == null) {
                throw new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Unrecognized namespace: " + xmlReader.getNamespaceURI() + " at [" + xmlReader.getLocation().getLineNumber() + "," + xmlReader.getLocation().getColumnNumber() + "]. Expecting a Soap 1.1 or 1.2 namespace.");
            }
            message.put(SoapVersion.class, soapVersion);
            if (!name.equals(soapVersion.getEnvelope())) {
                if (name.getLocalPart().equals(soapVersion.getEnvelope().getLocalPart())) {
                    throw new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Expected a SOAP " + soapVersion.getVersion() + " request");
                }
                throw new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Unrecognized element: " + xmlReader.getName() + " at [" + xmlReader.getLocation().getLineNumber() + "," + xmlReader.getLocation().getColumnNumber() + "]. Expecting 'Envelope'.");
            }
            xmlReader.nextTag();
            if (xmlReader.getName().equals(soapVersion.getHeader())) {
                Map<QName, DocumentFragment> headers = message.getSoapHeaders();
                while (xmlReader.nextTag() != 2) {
                    QName hn = xmlReader.getName();
                    Element e = StaxUtil.createElement(xmlReader);
                    DocumentFragment df = headers.get(hn);
                    if (df == null) {
                        df = e.getOwnerDocument().createDocumentFragment();
                    }
                    e = (Element)df.getOwnerDocument().importNode(e, true);
                    df.appendChild(e);
                    headers.put(hn, df);
                }
                xmlReader.nextTag();
            }
            if (!xmlReader.getName().equals(soapVersion.getBody())) {
                throw new SoapFault(SoapFault.SENDER, "Unrecognized element: " + xmlReader.getName() + ". Expecting 'Body'.");
            }
            if (xmlReader.nextTag() == 2) {
                message.setContent(XMLStreamReader.class, null);
            }
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }
}

