/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.jbi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapBinding;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapMessage;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapOperation;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapPart;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.interceptors.jbi.JbiConstants;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.util.QNameUtil;
import org.apache.servicemix.soap.util.stax.DOMStreamReader;
import org.apache.servicemix.soap.util.stax.ExtendedXMLStreamReader;
import org.apache.servicemix.soap.util.stax.FragmentStreamReader;
import org.apache.servicemix.soap.util.stax.StaxSource;
import org.apache.servicemix.soap.util.stax.StaxUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JbiInWsdl1Interceptor
extends AbstractInterceptor {
    private final boolean server;

    public JbiInWsdl1Interceptor(boolean server) {
        this.server = server;
    }

    public void handleMessage(Message message) {
        if (message.getContent(Exception.class) != null) {
            return;
        }
        if (message.get("useJbiWrapper") instanceof Boolean && !((Boolean)message.get("useJbiWrapper")).booleanValue()) {
            XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
            if (xmlReader != null) {
                message.setContent(Source.class, StaxUtil.createSource(xmlReader));
            }
            return;
        }
        try {
            StaxJbiWrapper reader = new StaxJbiWrapper(message);
            message.setContent(Source.class, new StaxSource(reader));
        }
        catch (UnsupportedOperationException e) {
            Document document = this.createDomWrapper(message);
            message.setContent(Source.class, new DOMSource(document));
        }
    }

    protected Document createDomWrapper(Message message) {
        Wsdl1SoapOperation wsdlOperation = this.getOperation(message);
        Wsdl1SoapMessage wsdlMessage = this.server ? (Wsdl1SoapMessage)wsdlOperation.getInput() : (Wsdl1SoapMessage)wsdlOperation.getOutput();
        Document document = DomUtil.createDocument();
        Element root = DomUtil.createElement(document, JbiConstants.WSDL11_WRAPPER_MESSAGE);
        String typeNamespace = wsdlMessage.getName().getNamespaceURI();
        if (typeNamespace == null || typeNamespace.length() == 0) {
            throw new IllegalArgumentException("messageType namespace is null or empty");
        }
        root.setAttribute("xmlns:msg", typeNamespace);
        String typeLocalName = wsdlMessage.getName().getLocalPart();
        if (typeLocalName == null || typeLocalName.length() == 0) {
            throw new IllegalArgumentException("messageType local name is null or empty");
        }
        root.setAttribute("type", "msg:" + typeLocalName);
        String messageName = wsdlMessage.getMessageName();
        root.setAttribute("name", messageName);
        root.setAttribute("version", "1.0");
        Element body = this.getBodyElement(message);
        for (Wsdl1SoapPart part : wsdlMessage.getParts()) {
            if (part.isBody()) {
                if (wsdlOperation.getStyle() == Wsdl1SoapBinding.Style.DOCUMENT) {
                    JbiInWsdl1Interceptor.addPart(root, body);
                    continue;
                }
                Element param = DomUtil.getFirstChildElement(body);
                boolean found = false;
                while (param != null) {
                    if (part.getName().equals(param.getLocalName())) {
                        found = true;
                        JbiInWsdl1Interceptor.addPart(root, param.getChildNodes());
                    }
                    param = DomUtil.getNextSiblingElement(param);
                }
                if (found) continue;
                throw new SoapFault(SoapFault.SENDER, "Missing part '" + part.getName() + "'");
            }
            QName element = part.getElement();
            DocumentFragment header = message.getSoapHeaders().remove(element);
            if (header == null) {
                throw new SoapFault(SoapFault.SENDER, "Missing required header element: " + QNameUtil.toString(element));
            }
            JbiInWsdl1Interceptor.addPart(root, header.getChildNodes());
        }
        return document;
    }

    protected Wsdl1SoapOperation getOperation(Message message) {
        Operation operation = message.get(Operation.class);
        if (operation == null) {
            throw new Fault("Operation not bound on this message");
        }
        if (!(operation instanceof Wsdl1SoapOperation)) {
            throw new Fault("Message is not bound to a WSDL 1.1 SOAP operation");
        }
        return (Wsdl1SoapOperation)operation;
    }

    protected Element getBodyElement(Message message) {
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        return xmlReader != null ? StaxUtil.createElement(xmlReader) : null;
    }

    private static void addPart(Element parent, Node partValue) {
        Element element = DomUtil.createElement(parent, JbiConstants.WSDL11_WRAPPER_PART);
        element.appendChild(element.getOwnerDocument().importNode(partValue, true));
    }

    private static void addPart(Element parent, NodeList nodes) {
        Element element = DomUtil.createElement(parent, JbiConstants.WSDL11_WRAPPER_PART);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            element.appendChild(element.getOwnerDocument().importNode(node, true));
        }
    }

    protected class StaxJbiWrapper
    implements XMLStreamReader {
        public static final int STATE_START_DOC = 0;
        public static final int STATE_START_ELEMENT_WRAPPER = 1;
        public static final int STATE_START_ELEMENT_PART = 2;
        public static final int STATE_RUN_PART = 3;
        public static final int STATE_END_ELEMENT_PART = 4;
        public static final int STATE_END_ELEMENT_WRAPPER = 5;
        public static final int STATE_END_DOC = 6;
        private Message message;
        private Wsdl1SoapMessage wsdlMessage;
        private int state = 0;
        private int part = -1;
        private int reader = -1;
        private int event = 7;
        private List<List<XMLStreamReader>> parts = new ArrayList<List<XMLStreamReader>>();

        public StaxJbiWrapper(Message message) {
            this.message = message;
            Wsdl1SoapOperation wsdlOperation = JbiInWsdl1Interceptor.this.getOperation(message);
            this.wsdlMessage = JbiInWsdl1Interceptor.this.server ? (Wsdl1SoapMessage)wsdlOperation.getInput() : (Wsdl1SoapMessage)wsdlOperation.getOutput();
            XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
            int nbBodyParts = 0;
            for (Wsdl1SoapPart part : this.wsdlMessage.getParts()) {
                if (part.isBody()) {
                    if (nbBodyParts++ > 0) {
                        throw new UnsupportedOperationException();
                    }
                    if (wsdlOperation.getStyle() == Wsdl1SoapBinding.Style.DOCUMENT) {
                        this.parts.add(Collections.singletonList(new FragmentStreamReader(xmlReader)));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                QName element = part.getElement();
                DocumentFragment header = message.getSoapHeaders().get(element);
                if (header == null) {
                    throw new SoapFault(SoapFault.SENDER, "Missing required header element: " + QNameUtil.toString(element));
                }
                ArrayList<DOMStreamReader> readers = new ArrayList<DOMStreamReader>();
                NodeList l = header.getChildNodes();
                for (int i = 0; i < l.getLength(); ++i) {
                    Node n = l.item(i);
                    if (!(n instanceof Element)) continue;
                    readers.add(new DOMStreamReader((Element)n));
                }
                this.parts.add(readers);
            }
            for (Wsdl1SoapPart part : this.wsdlMessage.getParts()) {
                if (part.isBody()) continue;
                message.getSoapHeaders().remove(part.getElement());
            }
        }

        public int getEventType() {
            return this.event;
        }

        public int next() throws XMLStreamException {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    this.event = 1;
                    break;
                }
                case 1: {
                    if (this.parts.size() > 0) {
                        this.state = 2;
                        this.event = 1;
                        this.part = 0;
                        this.reader = 0;
                        break;
                    }
                    this.state = 5;
                    this.event = 2;
                    break;
                }
                case 2: {
                    if (this.reader >= this.parts.get(this.part).size()) {
                        this.state = 4;
                        this.event = 2;
                        break;
                    }
                    this.state = 3;
                    this.event = this.parts.get(this.part).get(this.reader).next();
                    if (this.event != 7) break;
                    this.event = this.parts.get(this.part).get(this.reader).next();
                    break;
                }
                case 3: {
                    this.event = this.parts.get(this.part).get(this.reader).next();
                    if (this.event != 8) break;
                    if (++this.reader >= this.parts.get(this.part).size()) {
                        this.state = 4;
                        this.event = 2;
                        break;
                    }
                    this.event = this.parts.get(this.part).get(this.reader).next();
                    if (this.event != 7) break;
                    this.event = this.parts.get(this.part).get(this.reader).next();
                    break;
                }
                case 4: {
                    if (++this.part >= this.parts.size()) {
                        this.state = 5;
                        this.event = 2;
                        break;
                    }
                    this.state = 2;
                    this.event = 1;
                    this.reader = 0;
                    break;
                }
                case 5: 
                case 6: {
                    this.state = 6;
                    this.event = 8;
                }
            }
            return this.event;
        }

        public QName getName() {
            switch (this.state) {
                case 1: 
                case 5: {
                    return JbiConstants.WSDL11_WRAPPER_MESSAGE;
                }
                case 2: 
                case 4: {
                    return JbiConstants.WSDL11_WRAPPER_PART;
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getName();
                }
            }
            throw new IllegalStateException();
        }

        public String getLocalName() {
            switch (this.state) {
                case 1: 
                case 5: {
                    return "message";
                }
                case 2: 
                case 4: {
                    return "part";
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getLocalName();
                }
            }
            throw new IllegalStateException();
        }

        public String getNamespaceURI() {
            switch (this.state) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    return "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getNamespaceURI();
                }
            }
            throw new IllegalStateException();
        }

        public String getPrefix() {
            switch (this.state) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    return "jbi";
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getPrefix();
                }
            }
            throw new IllegalStateException();
        }

        public boolean hasName() {
            return this.state == 3 ? this.parts.get(this.part).get(this.reader).isStartElement() : this.event == 1 || this.event == 2;
        }

        public Object getProperty(String s) throws IllegalArgumentException {
            return null;
        }

        public void require(int i, String s, String s1) throws XMLStreamException {
        }

        public String getElementText() throws XMLStreamException {
            return null;
        }

        public int nextTag() throws XMLStreamException {
            while (this.hasNext()) {
                int e = this.next();
                if (e != 1 && e != 2) continue;
                return e;
            }
            return this.event;
        }

        public boolean hasNext() throws XMLStreamException {
            return this.event != 8;
        }

        public void close() throws XMLStreamException {
        }

        public String getNamespaceURI(String s) {
            return null;
        }

        public boolean isStartElement() {
            return this.state == 3 ? this.parts.get(this.part).get(this.reader).isStartElement() : this.event == 1;
        }

        public boolean isEndElement() {
            return this.state == 3 ? this.parts.get(this.part).get(this.reader).isEndElement() : this.event == 2;
        }

        public boolean isCharacters() {
            return this.state == 3 ? this.parts.get(this.part).get(this.reader).isCharacters() : this.event == 4;
        }

        public boolean isWhiteSpace() {
            return this.state == 3 ? this.parts.get(this.part).get(this.reader).isWhiteSpace() : this.event == 6;
        }

        public String getAttributeValue(String s, String s1) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public int getAttributeCount() {
            switch (this.state) {
                case 1: {
                    return 4;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getAttributeCount();
                }
            }
            throw new IllegalStateException();
        }

        public QName getAttributeName(int i) {
            switch (this.state) {
                case 1: {
                    switch (i) {
                        case 0: {
                            return new QName("http://www.w3.org/2000/xmlns/", "msg", "xmlns");
                        }
                        case 1: {
                            return new QName("type");
                        }
                        case 2: {
                            return new QName("name");
                        }
                        case 3: {
                            return new QName("version");
                        }
                    }
                    throw new IllegalStateException();
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getAttributeName(i);
                }
            }
            throw new IllegalStateException();
        }

        public String getAttributeNamespace(int i) {
            switch (this.state) {
                case 1: {
                    switch (i) {
                        case 0: {
                            return "http://www.w3.org/2000/xmlns/";
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            return "";
                        }
                    }
                    throw new IllegalStateException();
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getAttributeNamespace(i);
                }
            }
            throw new IllegalStateException();
        }

        public String getAttributeLocalName(int i) {
            switch (this.state) {
                case 1: {
                    switch (i) {
                        case 0: {
                            return "msg";
                        }
                        case 1: {
                            return "type";
                        }
                        case 2: {
                            return "name";
                        }
                        case 3: {
                            return "version";
                        }
                    }
                    throw new IllegalStateException();
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getAttributeLocalName(i);
                }
            }
            throw new IllegalStateException();
        }

        public String getAttributePrefix(int i) {
            switch (this.state) {
                case 1: {
                    switch (i) {
                        case 0: {
                            return "xmlns";
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            return "";
                        }
                    }
                    throw new IllegalStateException();
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getAttributePrefix(i);
                }
            }
            throw new IllegalStateException();
        }

        public String getAttributeType(int i) {
            return "CDATA";
        }

        public String getAttributeValue(int i) {
            switch (this.state) {
                case 1: {
                    switch (i) {
                        case 0: {
                            String typeNamespace = this.wsdlMessage.getName().getNamespaceURI();
                            if (typeNamespace == null || typeNamespace.length() == 0) {
                                throw new IllegalArgumentException("messageType namespace is null or empty");
                            }
                            return typeNamespace;
                        }
                        case 1: {
                            String typeLocalName = this.wsdlMessage.getName().getLocalPart();
                            if (typeLocalName == null || typeLocalName.length() == 0) {
                                throw new IllegalArgumentException("messageType local name is null or empty");
                            }
                            return "msg:" + typeLocalName;
                        }
                        case 2: {
                            return this.wsdlMessage.getMessageName();
                        }
                        case 3: {
                            return "1.0";
                        }
                    }
                    throw new IllegalStateException();
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getAttributeValue(i);
                }
            }
            throw new IllegalStateException();
        }

        public boolean isAttributeSpecified(int i) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public int getNamespaceCount() {
            switch (this.state) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    return 0;
                }
                case 3: {
                    return this.parts.get(this.part).get(this.reader).getNamespaceCount();
                }
            }
            throw new IllegalStateException();
        }

        public String getNamespacePrefix(int i) {
            return this.parts.get(this.part).get(this.reader).getNamespacePrefix(i);
        }

        public String getNamespaceURI(int i) {
            return this.parts.get(this.part).get(this.reader).getNamespaceURI(i);
        }

        public NamespaceContext getNamespaceContext() {
            if (this.state == 3) {
                return this.parts.get(this.part).get(this.reader).getNamespaceContext();
            }
            return new ExtendedXMLStreamReader.SimpleNamespaceContext();
        }

        public String getText() {
            if (this.state == 3) {
                return this.parts.get(this.part).get(this.reader).getText();
            }
            throw new IllegalStateException();
        }

        public char[] getTextCharacters() {
            if (this.state == 3) {
                return this.parts.get(this.part).get(this.reader).getTextCharacters();
            }
            throw new IllegalStateException();
        }

        public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
            if (this.state == 3) {
                return this.parts.get(this.part).get(this.reader).getTextCharacters(i, chars, i1, i2);
            }
            throw new IllegalStateException();
        }

        public int getTextStart() {
            if (this.state == 3) {
                return this.parts.get(this.part).get(this.reader).getTextStart();
            }
            throw new IllegalStateException();
        }

        public int getTextLength() {
            if (this.state == 3) {
                return this.parts.get(this.part).get(this.reader).getTextLength();
            }
            throw new IllegalStateException();
        }

        public String getEncoding() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean hasText() {
            if (this.state == 3) {
                return this.parts.get(this.part).get(this.reader).hasText();
            }
            return false;
        }

        public Location getLocation() {
            return new Location(){

                public int getCharacterOffset() {
                    return 0;
                }

                public int getColumnNumber() {
                    return 0;
                }

                public int getLineNumber() {
                    return 0;
                }

                public String getPublicId() {
                    return null;
                }

                public String getSystemId() {
                    return null;
                }
            };
        }

        public String getVersion() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isStandalone() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean standaloneSet() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getCharacterEncodingScheme() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getPITarget() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getPIData() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

