/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComplexCondition<T>
implements SearchCondition<T> {
    protected List<SearchCondition<T>> conditions;
    private ConditionType cType;

    protected AbstractComplexCondition(ConditionType cType) {
        this.cType = cType;
    }

    protected AbstractComplexCondition(List<SearchCondition<T>> conditions, ConditionType cType) {
        this.conditions = conditions;
        this.cType = cType;
    }

    public void setConditions(List<SearchCondition<T>> conditions) {
        this.conditions = conditions;
    }

    @Override
    public List<T> findAll(Collection<T> pojos) {
        ArrayList<T> result = new ArrayList<T>();
        for (T pojo : pojos) {
            if (!this.isMet(pojo)) continue;
            result.add(pojo);
        }
        return result;
    }

    @Override
    public T getCondition() {
        return null;
    }

    @Override
    public ConditionType getConditionType() {
        return this.cType;
    }

    @Override
    public List<SearchCondition<T>> getSearchConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    @Override
    public PrimitiveStatement getStatement() {
        return null;
    }

    public String toSQL(String table, String ... columns) {
        return SearchUtils.toSQL(this, table, columns);
    }

    @Override
    public void accept(SearchConditionVisitor<T> visitor) {
        visitor.visit(this);
    }
}

