/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.component.logger;

import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.servicemix.component.logger.LoggerLifecycle;
import org.servicemix.component.logger.LoggerReciever;
import org.servicemix.component.logger.LoggerServiceUnitManager;

public class LoggerServiceUnit {
    private String serviceUnitName;
    private static String url = "http://tempuri.org/logger";
    private LoggerLifecycle lifeCycle;
    private ServiceEndpoint endPoint;
    private MessageExchangeFactory exchange;

    public LoggerServiceUnit(LoggerServiceUnitManager manager, String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        this.lifeCycle = manager.getLifecycle();
        this.serviceUnitName = serviceUnitName;
        try {
            this.endPoint = this.lifeCycle.getComponentContext().activateEndpoint(new QName(url, serviceUnitName), "Consumer");
        }
        catch (JBIException e) {
            throw new DeploymentException("Unable to deploy endpoint", (Throwable)e);
        }
    }

    public void start() throws DeploymentException {
        try {
            this.exchange = this.lifeCycle.getComponentContext().getDeliveryChannel().createExchangeFactory(this.endPoint);
            LoggerReciever reciever = new LoggerReciever(this.lifeCycle.getComponentContext().getDeliveryChannel());
            reciever.run();
        }
        catch (JBIException e) {
            throw new DeploymentException("Unable to create end point for Logger service unit [" + this.serviceUnitName + "]", (Throwable)e);
        }
    }

    public void stop() throws DeploymentException {
        if (this.endPoint != null) {
            try {
                this.lifeCycle.getComponentContext().deactivateEndpoint(this.endPoint);
            }
            catch (JBIException e) {
                throw new DeploymentException("Unable to deactive endpoint", (Throwable)e);
            }
        }
    }
}

