/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicemix.components.util;

import org.springframework.beans.factory.InitializingBean;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;

/**
 * A Java based transformation component using a plugable {@link MessageTransformer} instance
 * to transform the input message into the output message.
 *
 * @version $Revision: 359151 $
 */
public class TransformComponent extends TransformComponentSupport implements InitializingBean {
    private MessageTransformer transformer;

    public void afterPropertiesSet() throws Exception {
        if (transformer == null) {
            throw new IllegalArgumentException("Must specify a transformer property");
        }
    }

    public MessageTransformer getTransformer() {
        return transformer;
    }

    public void setTransformer(MessageTransformer transformer) {
        this.transformer = transformer;
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        return transformer.transform(exchange, in, out);
    }
}
