/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.classloader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.xbean.server.classloader.MultiParentClassLoader;

public class JarFileClassLoader
extends MultiParentClassLoader {
    private static final URL[] EMPTY_URLS = new URL[0];
    private final Object lock = new Object();
    private final LinkedHashMap classPath = new LinkedHashMap();
    private boolean destroyed = false;

    public JarFileClassLoader(String name, URL[] urls) {
        super(name, EMPTY_URLS);
        this.addURLs(urls);
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader parent) {
        this(name, urls, new ClassLoader[]{parent});
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(name, urls, new ClassLoader[]{parent}, factory);
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader[] parents) {
        super(name, EMPTY_URLS, parents);
        this.addURLs(urls);
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader[] parents, URLStreamHandlerFactory factory) {
        super(name, EMPTY_URLS, parents, factory);
        this.addURLs(urls);
    }

    public URL[] getURLs() {
        return ((HashMap)this.classPath).keySet().toArray(new URL[((HashMap)this.classPath).keySet().size()]);
    }

    protected void addURL(URL url) {
        this.addURLs(Collections.singletonList(url));
    }

    protected void addURLs(URL[] urls) {
        this.addURLs(Arrays.asList(urls));
    }

    protected void addURLs(List urls) {
        LinkedList locationStack = new LinkedList(urls);
        try {
            while (!locationStack.isEmpty()) {
                Attributes mainAttributes;
                String manifestClassPath;
                JarFile jarFile;
                File file;
                URL url = (URL)locationStack.removeFirst();
                if (!"file".equals(url.getProtocol())) {
                    throw new Error("Only local file jars are supported " + url);
                }
                String path = url.getPath();
                if (this.classPath.containsKey(path) || !(file = new File(path)).canRead()) continue;
                try {
                    jarFile = new JarFile(file);
                }
                catch (IOException e) {
                    continue;
                }
                this.classPath.put(url, jarFile);
                Manifest manifest = null;
                try {
                    manifest = jarFile.getManifest();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                if (manifest == null || (manifestClassPath = (mainAttributes = manifest.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) == null) continue;
                LinkedList<String> classPathUrls = new LinkedList<String>();
                StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
                while (tokenizer.hasMoreTokens()) {
                    String entry = tokenizer.nextToken();
                    File parentDir = file.getParentFile();
                    File entryFile = new File(parentDir, entry);
                    if (!entryFile.canRead()) continue;
                    classPathUrls.addLast(entryFile.getAbsolutePath());
                }
                locationStack.addAll(0, classPathUrls);
            }
        }
        catch (Error e) {
            this.destroy();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            Iterator iterator = ((HashMap)this.classPath).values().iterator();
            while (iterator.hasNext()) {
                JarFile jarFile = (JarFile)iterator.next();
                try {
                    jarFile.close();
                }
                catch (IOException ignored) {}
            }
            this.classPath.clear();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String resourceName) {
        URL jarUrl = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return null;
            }
            Iterator iterator = ((HashMap)this.classPath).entrySet().iterator();
            while (iterator.hasNext() && jarUrl == null) {
                Map.Entry entry = iterator.next();
                JarFile jarFile = (JarFile)entry.getValue();
                JarEntry jarEntry = jarFile.getJarEntry(resourceName);
                if (jarEntry == null || jarEntry.isDirectory()) continue;
                jarUrl = (URL)entry.getKey();
            }
        }
        try {
            String urlString = "jar:" + jarUrl + "!/" + resourceName;
            return new URL(jarUrl, urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration findResources(String resourceName) throws IOException {
        ArrayList<Object> resources = new ArrayList<Object>();
        ArrayList superResources = Collections.list(super.findResources(resourceName));
        resources.addAll(superResources);
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
            Iterator iterator = ((HashMap)this.classPath).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                JarFile jarFile = (JarFile)entry.getValue();
                JarEntry jarEntry = jarFile.getJarEntry(resourceName);
                if (jarEntry == null || jarEntry.isDirectory()) continue;
                try {
                    URL url = (URL)entry.getKey();
                    String urlString = "jar:" + url + "!/" + resourceName;
                    resources.add(new URL(url, urlString));
                }
                catch (MalformedURLException e) {}
            }
        }
        return Collections.enumeration(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String className) throws ClassNotFoundException {
        byte[] bytes;
        int packageEnd;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (packageEnd = className.lastIndexOf(46)) >= 0) {
            String packageName = className.substring(0, packageEnd);
            securityManager.checkPackageDefinition(packageName);
        }
        Certificate[] certificates = null;
        URL jarUrl = null;
        Manifest manifest = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                throw new ClassNotFoundException("Class loader has been destroyed: " + className);
            }
            try {
                String entryName = className.replace('.', '/') + ".class";
                InputStream inputStream = null;
                Iterator iterator = ((HashMap)this.classPath).entrySet().iterator();
                while (iterator.hasNext() && inputStream == null) {
                    Map.Entry entry = iterator.next();
                    jarUrl = (URL)entry.getKey();
                    JarFile jarFile = (JarFile)entry.getValue();
                    JarEntry jarEntry = jarFile.getJarEntry(entryName);
                    if (jarEntry == null || jarEntry.isDirectory()) continue;
                    inputStream = jarFile.getInputStream(jarEntry);
                    certificates = jarEntry.getCertificates();
                    manifest = jarFile.getManifest();
                }
                if (inputStream == null) {
                    throw new ClassNotFoundException(className);
                }
                try {
                    byte[] buffer = new byte[4096];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int count = inputStream.read(buffer);
                    while (count >= 0) {
                        out.write(buffer, 0, count);
                        count = inputStream.read(buffer);
                    }
                    bytes = out.toByteArray();
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className, e);
            }
        }
        this.definePackage(className, jarUrl, manifest);
        CodeSource codeSource = new CodeSource(jarUrl, certificates);
        Class<?> clazz = this.defineClass(className, bytes, 0, bytes.length, codeSource);
        return clazz;
    }

    private void definePackage(String className, URL jarUrl, Manifest manifest) {
        Package pkg;
        int packageEnd = className.lastIndexOf(46);
        if (packageEnd < 0) {
            return;
        }
        String packageName = className.substring(0, packageEnd);
        String packagePath = packageName.replace('.', '/') + "/";
        Attributes packageAttributes = null;
        Attributes mainAttributes = null;
        if (manifest != null) {
            packageAttributes = manifest.getAttributes(packagePath);
            mainAttributes = manifest.getMainAttributes();
        }
        if ((pkg = this.getPackage(packageName)) != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(jarUrl)) {
                    throw new SecurityException("Package was already sealed with another URL: package=" + packageName + ", url=" + jarUrl);
                }
            } else if (this.isSealed(packageAttributes, mainAttributes)) {
                throw new SecurityException("Package was already been loaded and not sealed: package=" + packageName + ", url=" + jarUrl);
            }
        } else {
            String specTitle = this.getAttribute(Attributes.Name.SPECIFICATION_TITLE, packageAttributes, mainAttributes);
            String specVendor = this.getAttribute(Attributes.Name.SPECIFICATION_VENDOR, packageAttributes, mainAttributes);
            String specVersion = this.getAttribute(Attributes.Name.SPECIFICATION_VERSION, packageAttributes, mainAttributes);
            String implTitle = this.getAttribute(Attributes.Name.IMPLEMENTATION_TITLE, packageAttributes, mainAttributes);
            String implVendor = this.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, packageAttributes, mainAttributes);
            String implVersion = this.getAttribute(Attributes.Name.IMPLEMENTATION_VERSION, packageAttributes, mainAttributes);
            URL sealBase = null;
            if (this.isSealed(packageAttributes, mainAttributes)) {
                sealBase = jarUrl;
            }
            this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }
    }

    private String getAttribute(Attributes.Name name, Attributes packageAttributes, Attributes mainAttributes) {
        String value;
        if (packageAttributes != null && (value = packageAttributes.getValue(name)) != null) {
            return value;
        }
        if (mainAttributes != null) {
            return mainAttributes.getValue(name);
        }
        return null;
    }

    private boolean isSealed(Attributes packageAttributes, Attributes mainAttributes) {
        String sealed = this.getAttribute(Attributes.Name.SEALED, packageAttributes, mainAttributes);
        if (sealed == null) {
            return false;
        }
        return "true".equalsIgnoreCase(sealed);
    }
}

