/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.xbean.server.classloader.NamedClassLoader;

public class MultiParentClassLoader
extends NamedClassLoader {
    private final ClassLoader[] parents;

    public MultiParentClassLoader(String name, URL[] urls) {
        super(name, urls);
        this.parents = new ClassLoader[0];
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader parent) {
        this(name, urls, new ClassLoader[]{parent});
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(name, urls, new ClassLoader[]{parent}, factory);
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents) {
        super(name, urls);
        this.parents = MultiParentClassLoader.copyParents(parents);
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents, URLStreamHandlerFactory factory) {
        super(name, urls, null, factory);
        this.parents = MultiParentClassLoader.copyParents(parents);
    }

    private static ClassLoader[] copyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new NullPointerException("parent[" + i + "] is null");
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    public ClassLoader[] getParents() {
        return this.parents;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        for (int i = 0; i < this.parents.length && clazz == null; ++i) {
            ClassLoader parent = this.parents[i];
            try {
                clazz = parent.loadClass(name);
                continue;
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (clazz == null) {
            return super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public URL getResource(String name) {
        URL url = null;
        for (int i = 0; i < this.parents.length && url == null; ++i) {
            ClassLoader parent = this.parents[i];
            url = parent.getResource(name);
        }
        if (url == null) {
            return super.getResource(name);
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader parent = this.parents[i];
            ArrayList<URL> parentResources = Collections.list(parent.getResources(name));
            resources.addAll(parentResources);
        }
        ArrayList<URL> myResources = Collections.list(super.findResources(name));
        resources.addAll(myResources);
        return Collections.enumeration(resources);
    }

    public String toString() {
        return "[" + this.getClass().getName() + ":" + " name=" + this.getName() + " urls=" + Arrays.asList(this.getURLs()) + " parents=" + Arrays.asList(this.parents) + "]";
    }
}

