/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import org.apache.xbean.server.classloader.ClassLoaderUtil;
import org.apache.xbean.server.classloader.DestroyableClassLoader;

public class NamedClassLoader
extends URLClassLoader
implements DestroyableClassLoader {
    private final String name;

    public NamedClassLoader(String name, URL[] urls) {
        super(urls);
        this.name = name;
    }

    public NamedClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.name = name;
    }

    public NamedClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.name = name;
    }

    public void destroy() {
        ClassLoaderUtil.destroy(this);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ":" + " name=" + this.getName() + " urls=" + Arrays.asList(this.getURLs()) + "]";
    }
}

