/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.main;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.KernelFactory;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.StaticServiceFactory;
import org.apache.xbean.kernel.StringServiceName;
import org.apache.xbean.server.main.FatalStartupError;
import org.apache.xbean.server.main.Main;

public class KernelMain
implements Main {
    private static final String DEFAULT_KERNEL_NAME = "xbean";
    private Kernel kernel;
    private ClassLoader classLoader;
    private Map services = Collections.EMPTY_MAP;
    private boolean daemon = true;
    private Main next;

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Map getServices() {
        return this.services;
    }

    public void setServices(Map services) {
        this.services = services;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public Main getNext() {
        return this.next;
    }

    public void setNext(Main next) {
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(String[] args) {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            if (this.kernel == null) {
                this.kernel = KernelFactory.newInstance().createKernel(DEFAULT_KERNEL_NAME);
            }
            boolean failed = false;
            try {
                Iterator iterator = this.services.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String name = (String)entry.getKey();
                    Object service = entry.getValue();
                    try {
                        StringServiceName serviceName = new StringServiceName(name);
                        this.kernel.registerService((ServiceName)serviceName, (ServiceFactory)new StaticServiceFactory(service), this.classLoader);
                        this.kernel.startService((ServiceName)serviceName);
                    }
                    catch (Exception e) {
                        throw new FatalStartupError("Unable to bind bootstrap service '" + name + "' into the kernel", e);
                    }
                }
                if (this.next != null) {
                    this.next.main(args);
                }
                if (this.daemon) {
                    Runtime.getRuntime().addShutdownHook(new DestroyKernelThread(this.kernel));
                    this.kernel.waitForDestruction();
                }
            }
            catch (RuntimeException e) {
                failed = true;
                throw e;
            }
            catch (Error e) {
                failed = true;
                throw e;
            }
            finally {
                block21: {
                    try {
                        this.kernel.destroy();
                    }
                    catch (Exception e) {
                        if (failed) break block21;
                        throw new FatalStartupError("Exception while shutting down kernel", e);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public void destroy() {
        if (this.kernel != null) {
            this.kernel.destroy();
        }
    }

    private static class DestroyKernelThread
    extends Thread {
        private final Kernel kernel;

        private DestroyKernelThread(Kernel kernel) {
            super("Destroy Kernel Shutdown Hook");
            this.kernel = kernel;
        }

        public void run() {
            this.kernel.destroy();
        }
    }
}

