/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.drools.dsl;

import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.drools.JbiHelper;
import org.apache.servicemix.components.drools.dsl.JbiConsequence;
import org.drools.rule.Rule;
import org.drools.smf.Configuration;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.FactoryException;
import org.drools.spi.Consequence;
import org.drools.spi.RuleBaseContext;
import org.drools.spi.Tuple;

public class ForwardConsequenceFactory
implements ConsequenceFactory {
    public Consequence newConsequence(Rule rule, RuleBaseContext ruleBaseContext, final Configuration configuration) throws FactoryException {
        final String[] services = configuration.getAttribute("service").split(",");
        return new JbiConsequence(){

            protected void invokeJbiOperation(JbiHelper helper, Tuple tuple) throws MessagingException {
                for (int i = 0; i < services.length; ++i) {
                    QName service = ForwardConsequenceFactory.this.toQName(configuration, services[i]);
                    helper.forwardToService(service, null, null);
                }
            }
        };
    }

    protected QName toQName(Configuration configuration, String text) {
        if (text == null) {
            return null;
        }
        String[] names = configuration.getAttributeNames();
        String localPart = text;
        String prefix = null;
        int idx = text.indexOf(58);
        if (idx >= 0) {
            prefix = "xmlns:" + text.substring(0, idx);
            localPart = text.substring(idx + 1);
        }
        String uri = "";
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (prefix == null) {
                if (!"xmlns".equals(name)) continue;
                uri = configuration.getAttribute(name);
                break;
            }
            if (!name.equals(prefix)) continue;
            uri = configuration.getAttribute(name);
            break;
        }
        System.out.println("Creating QName with uri: " + uri + " name: " + localPart);
        return new QName(uri, localPart);
    }
}

