/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.http;

import java.util.Iterator;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;

public class HttpClientMarshaler {
    protected SourceTransformer sourceTransformer = new SourceTransformer();
    private boolean streaming;
    private String contentType = "text/xml";

    public HttpClientMarshaler() {
        this(false);
    }

    public HttpClientMarshaler(boolean streaming) {
        this.streaming = streaming;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void toNMS(NormalizedMessage normalizedMessage, HttpMethod method) throws Exception {
        this.addNmsProperties(normalizedMessage, method);
        if (this.streaming) {
            normalizedMessage.setContent((Source)new StreamSource(method.getResponseBodyAsStream()));
        } else {
            normalizedMessage.setContent((Source)new StringSource(method.getResponseBodyAsString()));
        }
    }

    public void fromNMS(PostMethod method, MessageExchange exchange, NormalizedMessage normalizedMessage) throws Exception, TransformerException {
        this.addHttpHeaders((HttpMethod)method, normalizedMessage);
        if (this.streaming) {
            method.setContentChunked(true);
            Source src = normalizedMessage.getContent();
            if (src instanceof StreamSource && ((StreamSource)src).getInputStream() != null) {
                method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(((StreamSource)src).getInputStream(), -1L));
            } else {
                String text = this.sourceTransformer.toString(normalizedMessage.getContent());
                method.setRequestEntity((RequestEntity)new StringRequestEntity(text));
            }
        } else {
            String text = this.sourceTransformer.toString(normalizedMessage.getContent());
            method.setRequestEntity((RequestEntity)new StringRequestEntity(text));
        }
    }

    protected void addHttpHeaders(HttpMethod method, NormalizedMessage message) {
        Iterator iter = message.getPropertyNames().iterator();
        while (iter.hasNext()) {
            Object value;
            String name = (String)iter.next();
            if (!this.shouldIncludeHeader(message, name, value = message.getProperty(name))) continue;
            method.addRequestHeader(name, value.toString());
        }
        if (method.getRequestHeader("Content-Type") == null) {
            method.setRequestHeader("Content-Type", this.contentType);
        }
    }

    protected void addNmsProperties(NormalizedMessage message, HttpMethod method) {
        Header[] headers = method.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            String name = header.getName();
            String value = header.getValue();
            message.setProperty(name, (Object)value);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return value instanceof String && !"Content-Length".equalsIgnoreCase(name) && !"Content-Type".equalsIgnoreCase(name);
    }
}

