/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.http;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.servicemix.components.http.HttpClientMarshaler;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class HttpSoapClientMarshaler
extends HttpClientMarshaler {
    public HttpSoapClientMarshaler() {
    }

    public HttpSoapClientMarshaler(boolean streaming) {
        super(streaming);
    }

    public void toNMS(NormalizedMessage normalizedMessage, HttpMethod method) throws Exception {
        this.addNmsProperties(normalizedMessage, method);
        String response = method.getResponseBodyAsString();
        Node node = this.sourceTransformer.toDOMNode((Source)new StringSource(response));
        CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
        NodeIterator iterator = cachedXPathAPI.selectNodeIterator(node, "/*/*[local-name()='Body']/*");
        Node root = iterator.nextNode();
        if (!(root instanceof Element)) {
            throw new IllegalStateException("Could not find body content");
        }
        Element element = (Element)root;
        for (Node parent = element.getParentNode(); parent != null; parent = parent.getParentNode()) {
            NamedNodeMap attributes = parent.getAttributes();
            if (attributes == null) continue;
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr att = (Attr)attributes.item(i);
                if (!att.getName().startsWith("xmlns:") || element.getAttributes().getNamedItemNS(att.getNamespaceURI(), att.getLocalName()) != null) continue;
                element.setAttributeNS(att.getNamespaceURI(), att.getName(), att.getValue());
            }
        }
        normalizedMessage.setContent((Source)new DOMSource(element));
    }

    public void fromNMS(PostMethod method, MessageExchange exchange, NormalizedMessage normalizedMessage) throws Exception {
        Element elem;
        this.addHttpHeaders((HttpMethod)method, normalizedMessage);
        Node node = this.sourceTransformer.toDOMNode(normalizedMessage.getContent());
        if (node instanceof Document) {
            elem = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            elem = (Element)node;
        } else {
            throw new UnsupportedOperationException();
        }
        Document document = this.sourceTransformer.createDocument();
        Element env = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "env:Envelope");
        document.appendChild(env);
        env.setAttribute("xmlns:env", "http://schemas.xmlsoap.org/soap/envelope/");
        Element body = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "env:Body");
        env.appendChild(body);
        body.appendChild(document.importNode(elem, true));
        String text = this.sourceTransformer.toString((Node)document);
        method.setRequestEntity((RequestEntity)new StringRequestEntity(text));
    }
}

