/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.http;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.components.http.HttpBinding;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HttpSoapInOutBinding
extends ComponentSupport
implements HttpBinding {
    protected XFire xfire;
    protected XFireServletController controller;
    protected Service service;
    protected boolean defaultInOut = true;
    protected String soapAction = "\"\"";
    protected SourceTransformer transformer;
    static /* synthetic */ Class class$org$apache$servicemix$components$http$HttpSoapInOutBinding$InOutService;
    static /* synthetic */ Class class$org$apache$servicemix$components$http$HttpSoapInOutBinding$InOnlyService;

    public void init(ComponentContext context) throws JBIException {
        super.init(context);
        this.xfire = new DefaultXFire();
        ObjectServiceFactory factory = new ObjectServiceFactory(this.xfire.getTransportManager(), (BindingProvider)new AegisBindingProvider());
        factory.setVoidOneWay(true);
        factory.setStyle("document");
        if (this.isDefaultInOut()) {
            this.service = factory.create(class$org$apache$servicemix$components$http$HttpSoapInOutBinding$InOutService == null ? (class$org$apache$servicemix$components$http$HttpSoapInOutBinding$InOutService = HttpSoapInOutBinding.class$("org.apache.servicemix.components.http.HttpSoapInOutBinding$InOutService")) : class$org$apache$servicemix$components$http$HttpSoapInOutBinding$InOutService);
            this.service.setInvoker((Invoker)new BeanInvoker((Object)new InOutService(this)));
        } else {
            this.service = factory.create(class$org$apache$servicemix$components$http$HttpSoapInOutBinding$InOnlyService == null ? (class$org$apache$servicemix$components$http$HttpSoapInOutBinding$InOnlyService = HttpSoapInOutBinding.class$("org.apache.servicemix.components.http.HttpSoapInOutBinding$InOnlyService")) : class$org$apache$servicemix$components$http$HttpSoapInOutBinding$InOnlyService);
            this.service.setInvoker((Invoker)new BeanInvoker((Object)new InOnlyService(this)));
        }
        this.xfire.getServiceRegistry().register(this.service);
        this.controller = new Controller(this.xfire);
        this.transformer = new SourceTransformer();
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.controller.doService(request, response);
    }

    public void invokeInOnly(Source source, MessageContext context) throws XFireFault {
        if (source == null) {
            throw new XFireFault("Invalid source.", XFireFault.SENDER);
        }
        try {
            if (this.soapAction != null) {
                XFireServletController.getResponse().setHeader("SOAPAction", this.soapAction);
            }
            DeliveryChannel channel = this.getDeliveryChannel();
            MessageExchangeFactory factory = channel.createExchangeFactory();
            InOnly exchange = factory.createInOnlyExchange();
            this.populateExchange((MessageExchange)exchange, source, context);
            boolean result = channel.sendSync((MessageExchange)exchange);
            if (!result) {
                throw new XFireFault("Error sending exchange", XFireFault.SENDER);
            }
        }
        catch (XFireFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new XFireFault((Throwable)e);
        }
    }

    public Source invokeInOut(Source source, MessageContext context) throws XFireFault {
        if (source == null) {
            throw new XFireFault("Invalid source.", XFireFault.SENDER);
        }
        try {
            if (this.soapAction != null) {
                XFireServletController.getResponse().setHeader("SOAPAction", this.soapAction);
            }
            DeliveryChannel channel = this.getDeliveryChannel();
            MessageExchangeFactory factory = channel.createExchangeFactory();
            InOut exchange = factory.createInOutExchange();
            this.populateExchange((MessageExchange)exchange, source, context);
            boolean result = channel.sendSync((MessageExchange)exchange);
            if (!result) {
                throw new XFireFault("Error sending exchange", XFireFault.SENDER);
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                Exception e = exchange.getError();
                if (e == null) {
                    throw new XFireFault("Received error", XFireFault.SENDER);
                }
                throw new XFireFault((Throwable)e, XFireFault.SENDER);
            }
            NormalizedMessage outMessage = exchange.getOutMessage();
            if (outMessage == null) {
                exchange.setError(new Exception("Expected an out message"));
                channel.sendSync((MessageExchange)exchange);
                throw new XFireFault("No response", XFireFault.SENDER);
            }
            Source src = exchange.getOutMessage().getContent();
            exchange.setStatus(ExchangeStatus.DONE);
            channel.send((MessageExchange)exchange);
            src = this.transformer.toDOMSource(src);
            return src;
        }
        catch (XFireFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new XFireFault((Throwable)e);
        }
    }

    protected void populateExchange(MessageExchange exchange, Source src, MessageContext ctx) throws Exception {
        Element element;
        NormalizedMessage inMessage = exchange.createMessage();
        Map namespaces = (Map)ctx.getProperty("declared.namespaces");
        Node node = this.transformer.toDOMNode(src);
        if (node instanceof Element) {
            element = (Element)node;
        } else if (node instanceof Document) {
            element = ((Document)node).getDocumentElement();
        } else {
            throw new UnsupportedOperationException("Unable to handle nodes of type " + node.getNodeType());
        }
        Iterator it = namespaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (element.getAttributes().getNamedItemNS("http://www.w3.org/2000/xmlns/", (String)entry.getKey()) != null) continue;
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)entry.getKey(), (String)entry.getValue());
        }
        inMessage.setContent((Source)new DOMSource(element));
        Attachments attachments = ctx.getInMessage().getAttachments();
        if (attachments != null) {
            Iterator it2 = attachments.getParts();
            while (it2.hasNext()) {
                Attachment part = (Attachment)it2.next();
                inMessage.addAttachment(part.getId(), part.getDataHandler());
            }
        }
        exchange.setMessage(inMessage, "in");
    }

    public boolean isDefaultInOut() {
        return this.defaultInOut;
    }

    public void setDefaultInOut(boolean defaultInOut) {
        this.defaultInOut = defaultInOut;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Controller
    extends XFireServletController {
        public Controller(XFire xfire) {
            super(xfire);
        }

        protected String getService(HttpServletRequest request) {
            return HttpSoapInOutBinding.this.service.getSimpleName();
        }
    }

    public static class InOutService {
        private HttpSoapInOutBinding component;

        public InOutService() {
        }

        public InOutService(HttpSoapInOutBinding component) {
            this.component = component;
        }

        public Source invokeInOut(Source source, MessageContext context) throws XFireFault {
            return this.component.invokeInOut(source, context);
        }
    }

    public static class InOnlyService {
        private HttpSoapInOutBinding component;

        public InOnlyService() {
        }

        public InOnlyService(HttpSoapInOutBinding component) {
            this.component = component;
        }

        public void invokeInOnly(Source source, MessageContext context) throws XFireFault {
            this.component.invokeInOnly(source, context);
        }
    }
}

