/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jms;

import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.jms.JmsMarshaler;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.RuntimeJBIException;

public class JmsInBinding
extends ComponentSupport
implements MessageListener,
MessageExchangeListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$components$jms$JmsInBinding == null ? (class$org$apache$servicemix$components$jms$JmsInBinding = JmsInBinding.class$("org.apache.servicemix.components.jms.JmsInBinding")) : class$org$apache$servicemix$components$jms$JmsInBinding));
    private JmsMarshaler marshaler = new JmsMarshaler();
    static /* synthetic */ Class class$org$apache$servicemix$components$jms$JmsInBinding;

    public JmsMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public void onMessage(Message jmsMessage) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received: " + jmsMessage));
        }
        try {
            InOnly messageExchange = this.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
            NormalizedMessage inMessage = messageExchange.createMessage();
            try {
                this.marshaler.toNMS(inMessage, jmsMessage);
                messageExchange.setInMessage(inMessage);
                this.getDeliveryChannel().send((MessageExchange)messageExchange);
            }
            catch (JMSException e) {
                messageExchange.setError((Exception)((Object)e));
                messageExchange.setStatus(ExchangeStatus.ERROR);
            }
        }
        catch (JBIException e) {
            throw new RuntimeJBIException(e);
        }
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

