/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.net;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.servicemix.components.net.FTPClientPool;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.components.util.PollingComponentSupport;

public class FTPPoller
extends PollingComponentSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$components$net$FTPPoller == null ? (class$org$apache$servicemix$components$net$FTPPoller = FTPPoller.class$("org.apache.servicemix.components.net.FTPPoller")) : class$org$apache$servicemix$components$net$FTPPoller));
    private FTPClientPool clientPool;
    private String path;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private Set workingSet = new CopyOnWriteArraySet();
    static /* synthetic */ Class class$org$apache$servicemix$components$net$FTPPoller;

    private String getWorkingPath() {
        return this.path == null ? "." : this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        FTPClient ftp = (FTPClient)this.borrowClient();
        try {
            FTPFile[] files = ftp.listFiles(this.getWorkingPath());
            for (int i = 0; i < files.length; ++i) {
                final FTPFile file = files[i];
                this.workingSet.add(file);
                this.getWorkManager().scheduleWork(new Work(){

                    public void run() {
                        FTPPoller.this.processFile(file);
                    }

                    public void release() {
                        FTPPoller.this.workingSet.remove(file);
                    }
                });
            }
        }
        finally {
            this.returnClient((SocketClient)ftp);
        }
    }

    public FTPClientPool getClientPool() {
        return this.clientPool;
    }

    public void setClientPool(FTPClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public Set getWorkingSet() {
        return this.workingSet;
    }

    protected void init() throws JBIException {
        if (this.clientPool == null) {
            throw new IllegalArgumentException("You must initialise the clientPool property");
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(FTPFile file) {
        if (file.getName().equals(".") || file.getName().equals("..")) {
            return;
        }
        FTPClient client = null;
        try {
            client = (FTPClient)this.borrowClient();
            this.processFile(client, file);
            if (!client.deleteFile(this.getWorkingPath() + file.getName())) {
                throw new IOException("Could not delete file " + file);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to process file: " + file + ". Reason: " + e), (Throwable)e);
        }
        finally {
            if (client != null) {
                this.returnClient((SocketClient)client);
            }
        }
    }

    protected void processFile(FTPClient client, FTPFile file) throws Exception {
        String name = file.getName();
        InputStream in = client.retrieveFileStream(this.getWorkingPath() + name);
        client.completePendingCommand();
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        this.marshaler.readMessage((MessageExchange)exchange, message, in, name);
        this.getDeliveryChannel().sendSync((MessageExchange)exchange);
        in.close();
    }

    protected SocketClient borrowClient() throws JBIException {
        try {
            return this.getClientPool().borrowClient();
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    protected void returnClient(SocketClient client) {
        if (client != null) {
            try {
                this.getClientPool().returnClient(client);
            }
            catch (Exception e) {
                log.error((Object)("Failed to return client to pool: " + e), (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

