/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.rss;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.components.util.OutBinding;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.ExpressionHelper;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;

public class FeedWriter
extends OutBinding {
    private String feedType = "atom_0.3";
    private SyndFeed cachedFeed;
    private String title;
    private String link = "http://servicemix.org/RSS";
    private Expression entryTitle;
    private Expression entryValue;
    private String feedDescription = "This feed is auto-generated by ServiceMix";
    private int maximumEntryCount = 200;
    private File feedFile;
    private String contentType = "text/plain";
    private SourceTransformer sourceTransformer = new SourceTransformer();
    private boolean loadOnStartup = true;

    public SyndFeed getCachedFeed() throws IllegalArgumentException, FeedException, IOException {
        if (this.cachedFeed == null) {
            this.cachedFeed = this.loadOrCreateFeed();
        }
        return this.cachedFeed;
    }

    public void setCachedFeed(SyndFeed feed) {
        this.cachedFeed = feed;
    }

    public String getFeedType() {
        return this.feedType;
    }

    public void setFeedType(String feedType) {
        this.feedType = feedType;
    }

    public String getFeedDescription() {
        return this.feedDescription;
    }

    public void setFeedDescription(String feedDescription) {
        this.feedDescription = feedDescription;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = "ServiceMix feed for service: " + this.getService();
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Expression getEntryTitle() {
        return this.entryTitle;
    }

    public void setEntryTitle(Expression title) {
        this.entryTitle = title;
    }

    public Expression getEntryValue() {
        return this.entryValue;
    }

    public void setEntryValue(Expression entryValue) {
        this.entryValue = entryValue;
    }

    public int getMaximumEntryCount() {
        return this.maximumEntryCount;
    }

    public void setMaximumEntryCount(int maximumEntryCount) {
        this.maximumEntryCount = maximumEntryCount;
    }

    public File getFeedFile() {
        if (this.feedFile == null) {
            throw new IllegalArgumentException("You must set the 'feedFile' property");
        }
        return this.feedFile;
    }

    public void setFeedFile(File feedFile) {
        this.feedFile = feedFile;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public SourceTransformer getSourceTransformer() {
        return this.sourceTransformer;
    }

    public void setSourceTransformer(SourceTransformer sourceTransformer) {
        this.sourceTransformer = sourceTransformer;
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    protected void init() throws JBIException {
        super.init();
        File file = this.getFeedFile();
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("Cannot generate the cachedFeed as the cachedFeed file is a directory: " + file);
        }
    }

    protected void process(MessageExchange exchange, NormalizedMessage message) throws Exception {
        SyndFeed feed = this.getCachedFeed();
        this.addMessageToFeed(feed, exchange, message);
        this.removeExpiredEntries(feed);
        this.writeFeed(feed, exchange, message);
        this.done(exchange);
    }

    protected void addMessageToFeed(SyndFeed feed, MessageExchange exchange, NormalizedMessage message) throws TransformerException, MessagingException {
        List entries = feed.getEntries();
        SyndEntry entry = this.createEntry(exchange, message);
        SyndContent description = this.createEntryContent(exchange, message);
        entry.setDescription(description);
        ArrayList<SyndEntry> temp = new ArrayList<SyndEntry>();
        temp.add(entry);
        temp.addAll(entries);
        feed.setEntries(temp);
    }

    protected SyndEntry createEntry(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle(ExpressionHelper.asString((Expression)this.getEntryTitle(), (MessageExchange)exchange, (NormalizedMessage)message, (String)"ServiceMix Feed"));
        entry.setLink(this.getLink());
        entry.setPublishedDate(new Date());
        return entry;
    }

    protected SyndContent createEntryContent(MessageExchange exchange, NormalizedMessage message) throws TransformerException, MessagingException {
        SyndContentImpl description = new SyndContentImpl();
        description.setType(this.contentType);
        Source content = message.getContent();
        String value = ExpressionHelper.asString((Expression)this.getEntryValue(), (MessageExchange)exchange, (NormalizedMessage)message, null);
        if (value == null && content != null) {
            value = this.getSourceTransformer().toString(content);
            value = this.encodeContent(value);
        }
        if (value != null) {
            description.setValue(value);
        }
        return description;
    }

    protected String encodeContent(String value) {
        return "<![CDATA[" + value + "]]>";
    }

    protected void writeFeed(SyndFeed feed, MessageExchange messageExchange, NormalizedMessage message) throws IOException, FeedException {
        FileWriter writer = new FileWriter(this.feedFile);
        SyndFeedOutput output = new SyndFeedOutput();
        output.output(feed, (Writer)writer);
        ((Writer)writer).close();
    }

    protected void removeExpiredEntries(SyndFeed feed) {
        List entries;
        int size;
        if (this.maximumEntryCount > 0 && (size = (entries = feed.getEntries()).size()) > this.maximumEntryCount) {
            entries.subList(this.maximumEntryCount, size).clear();
        }
    }

    protected SyndFeed loadOrCreateFeed() throws IllegalArgumentException, FeedException, IOException {
        File file;
        if (this.isLoadOnStartup() && (file = this.getFeedFile()).exists() && file.isFile()) {
            SyndFeedInput input = new SyndFeedInput();
            XmlReader xmlReader = new XmlReader(file);
            return input.build((Reader)xmlReader);
        }
        return this.createFeed();
    }

    protected SyndFeed createFeed() {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(this.feedType);
        feed.setTitle(this.getTitle());
        feed.setLink(this.getLink());
        feed.setDescription(this.getFeedDescription());
        return feed;
    }
}

