/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.vfs;

import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.components.util.OutBinding;
import org.apache.servicemix.components.vfs.FileObjectEditor;

public class FileWriter
extends OutBinding {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$components$vfs$FileWriter == null ? (class$org$apache$servicemix$components$vfs$FileWriter = FileWriter.class$("org.apache.servicemix.components.vfs.FileWriter")) : class$org$apache$servicemix$components$vfs$FileWriter));
    private FileObject directory;
    private FileObjectEditor editor = new FileObjectEditor();
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String uniqueFileName = "ServiceMix";
    static /* synthetic */ Class class$org$apache$servicemix$components$vfs$FileWriter;

    public FileObject getDirectory() {
        return this.directory;
    }

    public void setDirectory(FileObject directory) {
        this.directory = directory;
    }

    public String getPath() {
        return this.editor.getPath();
    }

    public void setPath(String path) {
        this.editor.setPath(path);
    }

    public FileSystemManager getFileSystemManager() {
        return this.editor.getFileSystemManager();
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.editor.setFileSystemManager(fileSystemManager);
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getUniqueFileName() {
        return this.uniqueFileName;
    }

    public void setUniqueFileName(String uniqueFileName) {
        this.uniqueFileName = uniqueFileName;
    }

    protected void init() throws JBIException {
        if (this.directory == null) {
            this.directory = this.editor.getFileObject();
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(MessageExchange exchange, NormalizedMessage message) throws Exception {
        OutputStream out = null;
        try {
            String name = this.marshaler.getOutputName(exchange, message);
            if (name == null) {
                throw new MessagingException("No output name available. Cannot output message!");
            }
            this.directory.close();
            FileObject newFile = this.directory.resolveFile(name);
            newFile.close();
            FileContent content = newFile.getContent();
            content.close();
            if (content != null) {
                out = content.getOutputStream();
            }
            if (out == null) {
                throw new MessagingException("No output stream available for output name: " + name);
            }
            this.marshaler.writeMessage(exchange, message, out, name);
            this.done(exchange);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

