/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.beanflow.Activity;
import org.apache.servicemix.beanflow.DefaultState;
import org.apache.servicemix.beanflow.JoinAll;
import org.apache.servicemix.beanflow.JoinSupport;
import org.apache.servicemix.beanflow.State;
import org.apache.servicemix.beanflow.TimeoutActivity;
import org.apache.servicemix.beanflow.support.Interpreter;
import org.apache.servicemix.beanflow.support.ReflectionInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workflow<T>
extends JoinSupport {
    private static final Log log = LogFactory.getLog(Workflow.class);
    private static final Class[] NO_PARAMETER_TYPES = new Class[0];
    private static final Object[] NO_PARAMETER_VALUES = new Object[0];
    private Executor executor;
    private Interpreter interpreter;
    private State<T> step;
    private T nextStep;
    private Timer timer = new Timer();
    private AtomicBoolean suspended = new AtomicBoolean();

    public Workflow(Class<T> enumType) {
        this(Workflow.getFirstStep(enumType));
    }

    public Workflow(T firstStep) {
        this(Executors.newSingleThreadExecutor(), firstStep);
    }

    public Workflow(Executor executor, T firstStep) {
        this(executor, new ReflectionInterpreter(), new DefaultState<T>(firstStep));
    }

    public Workflow(Executor executor, Interpreter interpreter, State<T> step) {
        this.executor = executor;
        this.interpreter = interpreter;
        this.step = step;
        T firstStep = step.get();
        if (firstStep instanceof Enum) {
            this.validateStepsExist(firstStep.getClass());
        }
    }

    public T getNextStep() {
        return this.nextStep;
    }

    public void setNextStep(T stepName) {
        this.nextStep = stepName;
        this.suspended.set(false);
        this.nextStep();
    }

    @Override
    public void run() {
        if (!this.isSuspended() && !this.isStopped()) {
            Object stepToExecute = null;
            if (this.nextStep != null) {
                stepToExecute = this.nextStep;
                this.nextStep = null;
                this.step.set(stepToExecute);
            } else {
                stepToExecute = this.step.get();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("About to execute step: " + stepToExecute));
            }
            if (stepToExecute != null) {
                this.interpreter.executeStep(stepToExecute, this);
                this.nextStep();
            }
        }
    }

    public void nextStep() {
        if (!this.isStopped() && !this.isSuspended()) {
            this.executor.execute(this);
        }
    }

    public void fork(TimeoutActivity ... activities) {
        for (TimeoutActivity activity : activities) {
            activity.start();
        }
    }

    public void fork(long timeout, TimeoutActivity ... activities) {
        for (TimeoutActivity activity : activities) {
            activity.scheduleTimeout(this.timer, timeout);
            activity.start();
        }
    }

    public void joinAll(T joinedStep, long timeout, Activity ... activities) {
        JoinAll joinFlow = new JoinAll(activities);
        this.join(joinFlow, joinedStep, timeout);
    }

    public void join(JoinSupport joinFlow, T joinedStep, long timeout) {
        this.fork(timeout, joinFlow);
        joinFlow.onStop(this.createGoToStepTask(joinedStep));
    }

    public void suspend() {
        this.suspended.set(true);
    }

    public boolean isSuspended() {
        return this.suspended.get();
    }

    public boolean isNextStepAvailable() {
        return this.nextStep != null;
    }

    public Runnable createGoToStepTask(final T joinedStep) {
        return new Runnable(){

            public void run() {
                Workflow.this.setNextStep(joinedStep);
                Workflow.this.nextStep();
            }
        };
    }

    public void onStepException(String stepName, Exception e) {
        log.warn((Object)("Step failed: " + stepName + ". Reason: " + e), (Throwable)e);
        this.suspend();
        this.fail("Failed to execute step: " + stepName + ". Reason: " + e, e);
    }

    @Override
    protected void onChildStateChange(int childCount, int stoppedCount, int failedCount) {
    }

    protected void validateStepsExist(Class enumType) {
        Object[] values = null;
        try {
            values = Workflow.getEnumValues(enumType);
        }
        catch (Exception e) {
            this.fail("Cannot get the values of the enumeration: " + enumType.getName(), e);
        }
        if (values != null) {
            this.interpreter.validateStepsExist(values, this);
        }
    }

    protected static Object getFirstStep(Class enumType) {
        try {
            Object[] values = Workflow.getEnumValues(enumType);
            return values[0];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find the values for the enumeration: " + enumType.getName() + ". Reason: " + e, e);
        }
    }

    protected static Object[] getEnumValues(Class enumType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = enumType.getMethod("values", NO_PARAMETER_TYPES);
        return (Object[])method.invoke(null, NO_PARAMETER_VALUES);
    }
}

