/*
 * Decompiled with CFR 0.152.
 */
package org.jencks;

import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jencks.JCAConnector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JCAContainer
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final transient Log log = LogFactory.getLog((Class)JCAContainer.class);
    private BootstrapContext bootstrapContext;
    private ResourceAdapter resourceAdapter;
    private ApplicationContext applicationContext;
    private boolean lazyLoad = false;

    public JCAConnector addConnector() {
        return new JCAConnector(this.getBootstrapContext(), this.getResourceAdapter());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resourceAdapter == null) {
            throw new IllegalArgumentException("resourceAdapter must be set");
        }
        if (this.bootstrapContext == null && this.bootstrapContext == null) {
            throw new IllegalArgumentException("bootstrapContext must be set");
        }
        this.resourceAdapter.start(this.bootstrapContext);
        if (!this.lazyLoad) {
            if (this.applicationContext == null) {
                throw new IllegalArgumentException("applicationContext should have been set by Spring");
            }
            this.applicationContext.getBeansOfType(JCAConnector.class);
        }
        String version = null;
        Package aPackage = Package.getPackage("org.jencks");
        if (aPackage != null) {
            version = aPackage.getImplementationVersion();
        }
        log.info((Object)("Jencks JCA Container (http://jencks.org/) has started running version: " + version));
    }

    public void destroy() throws Exception {
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }
}

